% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingEx.R
\name{samplingEx}
\alias{samplingEx}
\title{Extracts samples from external populations}
\usage{
samplingEx(
  population,
  response_column,
  degree_column,
  categorical_column,
  id_column,
  degree = NULL,
  net = NULL,
  seeds = 10,
  coupon = 2,
  waves = NULL,
  size = 300,
  prob = NULL,
  prop_sam = NULL,
  showids = TRUE,
  timeInterval = NULL
)
}
\arguments{
\item{population}{.csv file containing the population details. The first
column should contain the individual's ID.}

\item{response_column}{Column including responses.}

\item{degree_column}{Column including degrees.}

\item{categorical_column}{Column including categories.}

\item{id_column}{Column including IDs.}

\item{degree}{.csv file containing the network sizes. If it's not provided,
the degree size would be the number of individuals in the networks provided.
If both the networks and the degrees are not provided, then it will randomly
produce degrees for each respondent.}

\item{net}{.csv file contains the individual's network. It should contain
the same format as the output of the 'net size table' given from the output
of the inbuilt function 'population'. If not provided, would randomly assign
individuals considering the degree.}

\item{seeds}{Number of seeds. It should be a positive integer.}

\item{coupon}{Number of coupons. It should be a positive integer.}

\item{waves}{Number of waves. It should be a positive integer.}

\item{size}{Sample size. It should be a positive integer.}

\item{prob}{Whether the seeds are selected probabilistically. If you want to
be selected randomly then leave it as 'NULL' If you want to relate it to a
variable, add the variable name, and it should be related. For example, if
the seeds selected should depend on the network size, then the 'network'
should be used. If it is inversely proportional, then it should enter as
'1/network'.}

\item{prop_sam}{If the individuals from the network of an individual should
be chosen randomly use "NULL". If the selection should be done
probabilistically, state the variable and how it should be related.}

\item{showids}{If TRUE, it displays the IDs being recruited.}

\item{timeInterval}{Days between recruitment waves. Zeroth wave is assumed
to recruit at the present day.}
}
\value{
RDS sample
}
\description{
Extract samples from populations that the user inputs from an
external source without using the inbuilt function `population` to simulate
a population. Data should be in .csv format. Inputs are recruited in the
format of the output given in the inbuilt function `population.`
}
\examples{
\donttest{
RDS.population <- population(N = 1000,p.ties = 0.6,minVal = 10,zeros = 0,
pr = .5,pa = .1, atype_char = "net",atype_res = "net*char")

# This should be replaced with a real world dataset.
RDS.samplingEx <- samplingEx(population=RDS.population$frame,
response_column="response", degree_column="network",
categorical_column="character", id_column="s", seeds = 40, coupon = 2,
waves =8)
}

# This function may take considerable time to produce output, depending on
# the computer's performance. For a quick reference to the expected result,
# a saved version of the output is available.
data(RDS.samplingEx)

}
