% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overoptimism.r
\name{sr_max_test}
\alias{sr_max_test}
\title{test for multiple Sharpe ratios.}
\usage{
sr_max_test(
  srs,
  df,
  ope = 1,
  kappa = 1,
  rho = 0,
  zeta_0 = 0,
  conf.level = 0.95,
  type = c("Bonferroni", "chi-bar-square", "Follman"),
  loglog = TRUE
)
}
\arguments{
\item{srs}{A vector of Sharpe ratios, quoted in terms of a given epoch.}

\item{df}{The number of \sQuote{degrees of freedom} of the Sharpe ratios,
which are assumed to have been measured over the same period.
The degrees of freedom are one less than the number of observed returns.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}

\item{kappa}{The kurtosis factor of returns. The value 1 corresponds to
Gaussian returns, while larger values are more kurtotic.}

\item{rho}{The assumed common correlation among returns.}

\item{zeta_0}{The cutoff for the test. We test whether all Signal-noise
ratios are equal to zeta_0.  This value is quoted in terms of the same epoch
as \code{srs}.}

\item{conf.level}{confidence level of the test. We perform a one-sided test.}

\item{type}{which method to apply.}

\item{loglog}{Whether to apply Hansen's \sQuote{log-log} adjustment to the
number of effective strategies tested. Not yet applied for Follman's test.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the value of the statistic.}
\item{parameter}{the degrees of freedom for the statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a one-sided confidence interval appropriate to the specified alternative hypothesis.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs tests for the hypothesis 
\deqn{\forall i \zeta_i \le \zeta_0}{all i: zeta_i <= zeta_0}
against the alternative
\deqn{\exists i zeta_i > \zeta_0}{exists i: zeta_i > zeta_0}

Multiple methods are supported for the test, including Bonferroni
correction, a chi-bar-square test, and Follman's test.

It is assumed that returns have a compound symmetric correlation structure.
That is, the correlation matrix has \eqn{\rho}{rho} on all off-diagonal
elements.
Returns are assumed to follow an elliptical distribution with kurtosis
factor \eqn{\kappa}{kappa}, which equals 1 in the case of Gaussian
returns. The kurtosis factor is one third the kurtosis of marginal returns.
}
\details{
A few test methodologies are supported. These are described in more
detail in Section 4.1 of \emph{The Sharpe Ratio: Statistics and Applications}.
\itemize{
\item Performs the Bonferroni correction as described in equation (4.8).
\item The chi-bar-square test described in section 4.1.3.
\item Follman's test, given in equation (4.20). This test
does not yet support Hansen's asymptotic correction and may not
produce confidence intervals.
}
Moreover, Hansen's \sQuote{log-log} adjustment is also optionally applied.
}
\examples{
# generate some fake data
ope <- 252
zeta0 <- 1.0
set.seed(1234)
zetas <- rsr(50, zeta=zeta0, df=ope*2, ope=ope)
sr_max_test(zetas,df=ope*2,ope=ope,type='Bonferroni')
sr_max_test(zetas,zeta_0=zeta0,df=ope*2,ope=ope,type='Bonferroni')
sr_max_test(zetas,zeta_0=zeta0,df=ope*2,ope=ope,type='chi-bar-square')
}
\references{
Pav, S. E. "The Sharpe Ratio: Statistics and Applications." CRC Press, 2021.

Pav, S. E. "Conditional inference on the asset with maximum Sharpe ratio."
2019 \url{https://arxiv.org/abs/1906.00573}

Follman, D. "A Simple Multivariate Test for One-Sided Alternatives." 
JASA, 91, no 434 (1996): 854-861. \doi{10.2307/2291680}

Hansen, P. R. "A Test for Superior Predictive Ability."
J. Bus. Ec. Stats, 23, no 4 (2005). \doi{10.1198/073500105000000063}
}
\seealso{
\code{\link{reannualize}}

sr_conditional_test
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{htest}
\keyword{overoptimism}
