% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dhs_test.R
\name{dHS.test}
\alias{dHS.test}
\title{dHSIC test for first-order separability of a spatio-temporal point process}
\usage{
dHS.test(
  X,
  sim.procedure = c("pure_per", "block_per"),
  nblocks = 7L,
  nperm = 1999L,
  nsim = 199L,
  bandwidth = NULL
)
}
\arguments{
\item{X}{A numeric matrix or data frame with at least three columns giving event coordinates
\eqn{(x, y, t)}.}

\item{sim.procedure}{Character string specifying the permutation strategy:
\code{"pure_per"} or \code{"block_per"}.}

\item{nblocks}{Integer (>= 2). Number of temporal blocks for block permutation (only for \code{"block_per"}).}

\item{nperm}{Integer (>= 1). Number of block permutations (only for \code{"block_per"}).}

\item{nsim}{Integer (>= 1). Number of pure permutations (only for \code{"pure_per"}).}

\item{bandwidth}{Optional numeric. Fixed bandwidth to use with \code{kernel = "gaussian.fixed"} in \code{dHSIC::dhsic}.
If a single value is provided, it is used for both the spatial and temporal variables.
If a vector of length 2 is provided, it is interpreted as \code{c(bw_space, bw_time)}.
If provided, the function also returns a fixed-bandwidth Monte Carlo p-value.
If \code{NULL}, only the adaptive-bandwidth Gaussian kernel (\code{kernel = "gaussian"}) is used.}
}
\value{
A list with components:
\describe{
\item{p.value}{Monte Carlo p-value based on the adaptive-bandwidth Gaussian kernel.}
\item{p.value.bw}{Monte Carlo p-value based on the fixed-bandwidth Gaussian kernel, or \code{NA} if \code{bandwidth = NULL}.}
\item{bandwidth_data}{Bandwidth selected by \code{dHSIC::dhsic(..., kernel = "gaussian")}.}
}
}
\description{
Performs a nonparametric test of first-order separability between space and time in a
spatio-temporal point process using the d-variable Hilbert--Schmidt independence
criterion (dHSIC). The test statistic evaluates whether the spatio-temporal intensity \eqn{\rho(u,t)} can be
written in the multiplicative form \eqn{\rho_1(u)\rho_2(t),\,\, (u,t)\in \mathbb{R}^2\times\mathbb{R}}, where \eqn{\rho_1} and \eqn{\rho_2} are nonnegative measurable functions.
}
\details{
Two permutation strategies are supported:
\describe{
\item{\code{"pure_per"}}{Randomly permutes the time component across events.}
\item{\code{"block_per"}}{Uses block-wise permutation of the time component via \code{\link{sim.procedures}}
with \code{method = "block"} to preserve short-range temporal dependence.}
}

The Monte Carlo p-value is computed with the standard +1 correction:
\eqn{(1 + \#\{T_i \ge T_{obs}\})/(B + 1)}, where \eqn{B} is the number of permutations.
}
\note{
The dHSIC method is implemented via the \pkg{dHSIC} package. When \code{sim.procedure = "pure_per"},
\code{dHS.test()} internally calls \code{dhsic} from R package \pkg{dHSIC} for computational efficiency.
}
\examples{
if (requireNamespace("dHSIC", quietly = TRUE)) {
  set.seed(123)
  X <- cbind(runif(100), runif(100), runif(100, 0, 10))

  # Pure permutation test
  result <- dHS.test(sim.procedure = "pure_per",
                     X = X, nsim = 199, bandwidth = 0.05)
  print(result$p.value)

  # Block permutation test
  result_block <- dHS.test(sim.procedure = "block_per", X = X,
                           nblocks = 5, nperm = 100, bandwidth = 0.05)
  print(result_block$p.value.bw)
}
}
\references{
Ghorbani, M., Vafaei, N. and Myllymäki, M. (2025).
A kernel-based test for the first-order separability of spatio-temporal point processes,
\emph{TEST}.
}
\seealso{
\code{\link{sim.procedures}}, \code{\link{block.permut}}, \code{\link{chi2.test}}
}
