% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checksharpSVbound.R
\name{checksharpSVbound}
\alias{checksharpSVbound}
\title{Check if the Smith and VanderWeele bound is sharp}
\usage{
checksharpSVbound(whichEst, sens = NULL, BF = NULL, pY1)
}
\arguments{
\item{whichEst}{Input string. Defining the causal estimand of interest.
Available options are as follows. (1) Risk ratio in the total
population: \code{"RR_tot"}, (2) Risk ratio in the subpopulation:
\code{"RR_sub"}, (3) Risk difference in the subpopulation: \code{"RD_sub"}. Note that
the SV bound for the risk difference in the total population is not sharp.}

\item{sens}{Possible method to input bounding factors (BF). \code{sens} can
be the output from sensitivityparametersM(), a data.frame with columns
'parameter' and 'value', or a name list with correct names (e.g.
\code{"BF_00"},  \code{"BF_10"}, etc.). If not supplied, bounding factors can be
entered manually as specified below.}

\item{BF}{Input vector. Is c(BF_00, BF_10) for the total population and
c(BF_0, BF_1) for the subpopulation. Must be equal to or above 1.
Can be inserted directly or as output from \code{sensitivityparametersM()}.}

\item{pY1}{Input vector. The probabilities c(P(Y=1|T=1,I_S=1), P(Y=1|T=0,I_S=1)).}
}
\value{
A string stating if the SV bound is sharp or not.
}
\description{
\code{checksharpSVbound()} returns a string that indicates if the SV bound is sharp.
}
\examples{

# Example where the bounding factor are specified manually.
checksharpSVbound(whichEst = "RR_sub", BF = c(1.56, 2), pY1 = c(0.33, 0.1))

# Example specifying the bounding factors from sensitivityparametersM().
# Risk ratio in the total population. DGP from the zika example.
V = matrix(c(1, 0, 0.85, 0.15), ncol = 2)
U = matrix(c(1, 0, 0.5, 0.5), ncol = 2)
Tr = c(-6.2, 1.75)
Y = c(-5.2, 5.0, -1.0)
S = matrix(c(1.2, 2.2, 0.0, 0.5, 2.0, -2.75, -4.0, 0.0), ncol = 4)
probT1 = 0.286
probT0 = 0.004
senspar = sensitivityparametersM(whichEst = "RR_tot", whichBound = "SV",
 Vval = V,  Uval = U, Tcoef = Tr, Ycoef = Y, Scoef = S, Mmodel = "L",
 pY1_T1_S1 = probT1, pY1_T0_S1 = probT0)
 
checksharpSVbound(whichEst = "RR_tot", sens = senspar, pY1 = c(probT1, probT0))

}
\references{
Smith, Louisa H., and Tyler J. VanderWeele. "Bounding bias due
to selection." Epidemiology (Cambridge, Mass.) 30.4 (2019): 509.

Zetterstrom S, Sjölander A, Waernbaum I. "Investigations of sharp bounds
for causal effects under selection bias." Statistical Methods in Medical
Research (2025).
}
