% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeds.R
\name{seed_gen}
\alias{seed_gen}
\title{Generate a vector of seeds}
\usage{
seed_gen(seed, n, sample_vector = 1:1e+06)
}
\arguments{
\item{seed}{A number, interpreted as an integer, or NULL (see
\code{\link[base:Random]{set.seed()}}).}

\item{n}{The number of seeds to generate.}

\item{sample_vector}{The values from which to sample (without replacement).}
}
\value{
An integer vector containing \code{n} randomly drawn values from
\code{sample_vector}.
}
\description{
\code{seed_gen()} generates a vector of seeds from a single seed.
}
\details{
\code{length(sample_vector)} must be >= \code{n}.

The values of \code{sample_vector} must be unique, positive integers.
}
\examples{
seeds1 <- seed_gen(
  seed = 1234,
  n = 10
)

seeds2 <- seed_gen(
  seed = 1234,
  n = 10,
  sample_vector = 1:100
)
}
