% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_trimAPM}
\alias{seasonder_trimAPM}
\title{Trim APM Data}
\usage{
seasonder_trimAPM(seasonder_apm_object, trimming)
}
\arguments{
\item{seasonder_apm_object}{A SeaSonde RAPM object containing the antenna pattern data.}

\item{trimming}{The number of points to trim from each end.}
}
\value{
The SeaSonde RAPM object with trimmed antenna pattern data and updated attributes.
}
\description{
This function trims a specified number of points from the beginning and end of the antenna pattern data.
}
\examples{
# Trim loops for a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
trimmed_obj <- seasonder_trimAPM(obj, 3)
}
