% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setSeaSondeRCS_FOR_SS_Smoothed}
\alias{seasonder_setSeaSondeRCS_FOR_SS_Smoothed}
\title{Set Smoothed Self-Spectra for First Order Region (FOR)}
\usage{
seasonder_setSeaSondeRCS_FOR_SS_Smoothed(seasonder_cs_object, FOR_SS_Smoothed)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object to which the smoothed FOR self-spectra will be assigned.}

\item{FOR_SS_Smoothed}{A matrix containing the smoothed self-spectra data.}
}
\value{
The updated \code{SeaSondeRCS} object with the smoothed self-spectra stored in the \code{FOR_data} attribute.
}
\description{
This function assigns a smoothed self-spectra (SS) matrix to the First Order Region (FOR) data
within a \code{SeaSondeRCS} object. This smoothed matrix is used in FOR processing to improve
the detection of the first-order region.
}
\details{
The function assigns the provided smoothed self-spectra matrix to the \code{FOR_data} attribute
of the \code{SeaSondeRCS} object. This matrix is typically generated using
\code{\link{seasonder_SmoothSS}} and applied to antenna 3.

\strong{Validation Considerations:}
\itemize{
\item The function currently lacks explicit validation for \code{FOR_SS_Smoothed}.
\item Future improvements should include checking whether \code{FOR_SS_Smoothed} is a matrix and
ensuring its dimensions match the original self-spectra structure.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_SmoothSS}} for generating the smoothed self-spectra.
\item \code{\link{seasonder_SmoothFORSS}} for applying smoothing and setting the result.
}
}
