% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_log.R
\name{seasonder_logAndAbort}
\alias{seasonder_logAndAbort}
\title{Log and Abort Message in SeaSondeR}
\usage{
seasonder_logAndAbort(msg, calling_function = NULL, ...)
}
\arguments{
\item{msg}{A character string indicating the message.}

\item{calling_function}{Function where the condition occurred. If NULL (default), the code determines the caller.}

\item{...}{Additional arguments passed to \code{rlang::abort}.}
}
\value{
This function does not return as it always aborts execution.
}
\description{
This function logs a message to the SeaSondeR logging system and aborts execution.
It prefixes the abort message with the name of the calling function.
}
\examples{
my_function <- function() {
  seasonder_logAndAbort("This is a message")
}
# Demonstrate abort without stopping execution
try(my_function(), silent = TRUE)

}
