% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_header}
\alias{seasonder_getSeaSondeRCS_header}
\title{Getter for header}
\usage{
seasonder_getSeaSondeRCS_header(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{SeaSondeRCS object}
}
\value{
A list containing the header data of the SeaSondeRCS object.
}
\description{
Getter for header
}
\examples{
# Create a minimal SeaSondeRCS object with a header attribute
cs_obj <- structure(list(data = list(a = 1, b = 2)), class = "SeaSondeRCS")
attr(cs_obj, "header") <- list(
  nSiteCodeName = "Station1",
  nDateTime = Sys.time(),
  nDopplerCells = 2,
  nRangeCells = 3
)
header_data <- seasonder_getSeaSondeRCS_header(cs_obj)
print(header_data)
}
