% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_exportRadialMetrics}
\alias{seasonder_exportRadialMetrics}
\title{Export Radial Metrics from a SeaSondeRCS Object}
\usage{
seasonder_exportRadialMetrics(seasonder_cs_object, AngSeg = list())
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC detection data and related metadata.}

\item{AngSeg}{An optional list of angular segments to be applied to the vector flag field (VFLG).
Each element should be a numeric vector of length 3 defining a segment. Default is an empty list.}
}
\value{
A data frame with 34 columns containing the computed radial metrics. The columns include geographic
coordinates, velocity components, range, bearing information, signal power metrics, noise thresholds,
and computed spectral parameters.
}
\description{
This function extracts and formats radial metrics from a SeaSondeRCS object for export.
It processes the MUSIC table, computes various spectral metrics, applies antenna pattern corrections,
and combines the results into a final data frame formatted according to predefined column specifications.
}
\details{
The function proceeds as follows:
\enumerate{
\item Retrieves the MUSIC table using \code{seasonder_getSeaSondeRCS_MUSIC} and the associated APM object.
\item Defines a template row with 34 predefined columns, initializing most numeric values to NA, except for
specific defaults such as \code{MSA1}, \code{MDA1}, and \code{MDA2} (set to 1440L).
\item Copies basic numeric fields and computes additional fields from the MUSIC table, such as the radial
velocity (scaled by 100), range, range cell, doppler cell (shifted by -1), eigenvalue ratio, signal power
ratio, and offset power ratio.
\item Computes the metric \code{MDRJ} by applying the function \code{seasonder_computeMDRJ} on the MUSIC row.
\item Extracts eigen decomposition results from each MUSIC row to populate the eigenvalue fields (\code{MEI1},
\code{MEI2}, \code{MEI3}).
\item Processes the DOA solutions stored in each MUSIC row:
- For solutions retained as "single", geographic bearing corrections are applied to populate \code{MSA1}.
- For dual-bearing solutions, the first two elements of the DOA bearings populate \code{MDA1} and
\code{MDA2}, respectively.
\item Computes additional spectral metrics such as the self-spectra conversion to dB (fields \code{MA1S},
\code{MA2S}, and \code{MA3S}) after subtracting the noise level (obtained for each antenna).
\item Based on the retained solution type (either "single" or "dual"), assigns location data (if available),
sets selection flags, and computes additional output metrics (e.g., \code{PPFG} and \code{PWFG}).
\item Finally, all rows are combined into a data frame. If angular segments are provided, additional modifications
to the vector flag (\code{VFLG}) are applied.
}
}
\examples{
\donttest{
# Prepare a SeaSondeRCS object with MUSIC data
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
FOR <- seasonder_getSeaSondeRCS_FOR(cs_obj)
cs_obj <- seasonder_setSeaSondeRCS_FOR(cs_obj,FOR[4:5])
# Run MUSIC algorithm to populate MUSIC data
cs_obj <- seasonder_runMUSICInFOR(cs_obj)
radial_metrics <- seasonder_exportRadialMetrics(cs_obj, AngSeg = list(c(5, 30, 60)))
head(radial_metrics)
}
}
