% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_createSeaSondeRCS.character}
\alias{seasonder_createSeaSondeRCS.character}
\title{Create a SeaSondeRCS object from a file path}
\usage{
\method{seasonder_createSeaSondeRCS}{character}(x, specs_path = rlang::zap(), endian = "big", ...)
}
\arguments{
\item{x}{A character string specifying the path to the SeaSonde CS file.}

\item{specs_path}{A character string specifying the path to the YAML specifications for the CS file.
If not provided or set to \code{rlang::zap()}, the default specifications path for the detected file type is used.}

\item{endian}{A character string indicating the byte order. Options are "big" (default) or "little".}

\item{...}{Additional parameters passed to \code{new_SeaSondeRCS} for creating the object.}
}
\value{
A SeaSondeRCS object.
}
\description{
This method creates a SeaSondeRCS object by reading a file from the specified file path.
It verifies the file's existence, determines the file type ("CS", "CSSY" or "CSSW") using
\code{seasonder_find_spectra_file_type}, and then reads the file using the appropriate function.
If \code{specs_path} is not provided (or is set to \code{rlang::zap()}), the default YAML specifications
file path is retrieved using \code{seasonder_defaultSpecsFilePath} based on the detected file type.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the file specified by \code{x} exists; if not, it aborts with an error.
\item Determines the file type using \code{seasonder_find_spectra_file_type}.
\item If \code{specs_path} is not provided or is set to \code{rlang::zap()}, retrieves the default YAML
specifications path using \code{seasonder_defaultSpecsFilePath} based on the detected file type.
\item Reads the file using the appropriate function:
\itemize{
\item \code{seasonder_readSeaSondeCSFile} for CS files.
\item \code{seasonder_readSeaSondeRCSSYFile} for CSSY files.
\item \code{seasonder_readSeaSondeRCSSWFile} for CSSW files.
}
\item Creates a SeaSondeRCS object using \code{new_SeaSondeRCS} with the header and data obtained from the file.
\item Appends a processing step indicating the creation source via \code{seasonder_setSeaSondeRCS_ProcessingSteps}
with a creation step text generated by \code{SeaSondeRCS_creation_step_text(x)}.
}
}
\examples{
# Create a SeaSondeRCS object from a file using the default YAML specifications
rcs_object <- seasonder_createSeaSondeRCS(
  system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
)

# Create a SeaSondeRCS object from a file with a specified YAML specifications file
rcs_object <- seasonder_createSeaSondeRCS(
  system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR"),
  specs_path = seasonder_defaultSpecsFilePath("CS")
)
}
\seealso{
\code{\link{new_SeaSondeRCS}},
\code{\link{seasonder_find_spectra_file_type}},
\code{\link{seasonder_defaultSpecsFilePath}},
\code{\link{seasonder_readSeaSondeCSFile}},
\code{\link{seasonder_readSeaSondeRCSSYFile}},
\code{\link{seasonder_readSeaSondeRCSSWFile}},
\code{\link{seasonder_setSeaSondeRCS_ProcessingSteps}},
\code{\link{SeaSondeRCS_creation_step_text}}
}
