% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_compute_antenna_pattern_proyections}
\alias{seasonder_compute_antenna_pattern_proyections}
\title{Compute Antenna Pattern Projections for the MUSIC Algorithm}
\usage{
seasonder_compute_antenna_pattern_proyections(En, a, Conj_t_a)
}
\arguments{
\item{En}{A matrix containing the eigenvectors of the noise subspace, derived from the
covariance matrix of the signals.}

\item{a}{A complex-valued vector representing the antenna manifold response for a specific
bearing. Each element corresponds to the response of an antenna element.}

\item{Conj_t_a}{The conjugate transpose of the antenna manifold vector \code{a}.}
}
\value{
A complex scalar representing the magnitude of the projection of the antenna
manifold vector onto the noise subspace. This value indicates how close the
antenna manifold vector is to being orthogonal to the noise subspace.
}
\description{
This function computes the projection of the antenna pattern vector onto the noise subspace,
a critical step in the Multiple Signal Classification (MUSIC) algorithm. It is used to estimate
the direction of arrival (DOA) by identifying the bearing that minimizes this projection.
}
\details{
The MUSIC algorithm leverages the property that the antenna manifold vector is orthogonal
to the noise subspace eigenvectors in an ideal scenario. However, in practice, noise in the
covariance matrix perturbs the noise subspace, resulting in a small but non-zero projection.
This function calculates the magnitude of this projection using the formula:

\deqn{P = a^H (En E_n^H) a}

where:
\itemize{
\item \eqn{a} is the antenna manifold vector.
\item \eqn{En} is the noise subspace eigenvector matrix.
\item \eqn{H} denotes the Hermitian (conjugate transpose) operator.
}

The bearing that produces the smallest projection is considered the best estimate of the signal bearing,
as it corresponds to the direction where the signal is strongest relative to the noise.
}
\section{References}{

\itemize{
\item Paolo, T. de, Cook, T., & Terrill, E. (2007). Properties of HF RADAR Compact Antenna Arrays and Their Effect on the MUSIC Algorithm. \emph{OCEANS 2007}, 1–10. doi:10.1109/oceans.2007.4449265.
}
}

