% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICExtractPeaksCheckRetainedSolution}
\alias{seasonder_MUSICExtractPeaksCheckRetainedSolution}
\title{Validate Retained Solution in MUSIC Algorithm Peak Extraction}
\usage{
seasonder_MUSICExtractPeaksCheckRetainedSolution(ret_sol, DOA_sol)
}
\arguments{
\item{ret_sol}{A character string specifying the initial solution type to retain. Valid values are \code{"single"} or \code{"dual"}.}

\item{DOA_sol}{A list containing extracted DOA solutions, as returned by \code{\link{seasonder_MUSICExtractDOASolutions}}.}
}
\value{
A character string indicating the validated solution type:
\itemize{
\item \code{"single"}: If only one single solution bearing is valid.
\item \code{"dual"}: If valid dual solution bearings are detected.
\item \code{"none"}: If no valid bearings are found.
}
}
\description{
This function verifies and adjusts the retained solution type ("single" or "dual") based on the
Direction of Arrival (DOA) solutions extracted using the MUSIC algorithm.
}
\details{
The function performs the following checks:
\enumerate{
\item If the retained solution is "dual" but no valid dual solution bearings exist, it defaults to "single" if valid.
\item If the retained solution is "single" but no valid single solution bearings exist, it defaults to "none".
}

This validation ensures the output solutions are consistent with the detected peaks, addressing potential discrepancies
in the initial assumptions about the solution type.
}
\seealso{
\code{\link{seasonder_MUSICExtractPeaks}}, \code{\link{seasonder_MUSICExtractDOASolutions}}
}
