% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICCheckSignalPowers}
\alias{seasonder_MUSICCheckSignalPowers}
\title{Validate Signal Power Ratios Using MUSIC Algorithm}
\usage{
seasonder_MUSICCheckSignalPowers(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing the MUSIC solutions and related data.}
}
\value{
The updated SeaSondeRCS object with the following modifications:
\itemize{
\item A new column \code{signal_power_ratio} in the MUSIC data.
\item A logical column \code{P2_check} indicating whether each solution passes the P2 test.
\item Updated \code{retained_solution} values for solutions that fail the test.
}
}
\description{
This function implements the P2 test for solutions derived using the MUSIC algorithm.
The test evaluates the ratio between the largest and smallest signal powers for dual-bearing solutions.
}
\details{
The P2 test is based on the ratio of the largest signal power (\eqn{P_{max}}) to the smallest signal power (\eqn{P_{min}}):

\deqn{Ratio = \frac{P_{max}}{P_{min}}}

This ratio is compared to a threshold defined in the MUSIC parameters. Only solutions that meet the following criteria are retained:
\itemize{
\item The solution has two bearings.
\item The signal power ratio is below the threshold.
}

Solutions failing this test are marked as "single."
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC}}, \code{\link{seasonder_setSeaSondeRCS_MUSIC}}
}
