% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{qc_check_unsigned}
\alias{qc_check_unsigned}
\title{Quality Control Check for Unsigned Values}
\usage{
qc_check_unsigned(field_value, expected_type = NULL)
}
\arguments{
\item{field_value}{The value to be checked. The function verifies if this value
is non-negative. It can be of any type but is typically expected to be a
numeric value.}

\item{expected_type}{An optional parameter specifying the expected data type of
\code{field_value}. If provided, the function first checks if \code{field_value}
matches the expected type before verifying if it is unsigned. Default is NULL,
which means no type check is performed.}
}
\value{
Returns the \code{field_value} if it passes the checks: it is of the expected
type (if \code{expected_type} is not NULL) and is non-negative. If any of the
checks fail, the function logs an error message and aborts execution.
}
\description{
This function performs a quality control check to ensure that a given field value
is an unsigned number (i.e., a non-negative number). Optionally, it can also
check if the field value matches a specified data type before performing the
unsigned check.
}
