% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{uni.slice}
\alias{uni.slice}
\title{Univariate Slice Sampler from Neal (2008)}
\usage{
uni.slice(x0, g, w = 1, m = Inf, lower = -Inf, upper = +Inf, gx0 = NULL)
}
\arguments{
\item{x0}{Initial point}

\item{g}{Function returning the log of the probability density (plus constant)}

\item{w}{Size of the steps for creating interval (default 1)}

\item{m}{Limit on steps (default infinite)}

\item{lower}{Lower bound on support of the distribution (default -Inf)}

\item{upper}{Upper bound on support of the distribution (default +Inf)}

\item{gx0}{Value of g(x0), if known (default is not known)}
}
\value{
The point sampled, with its log density attached as an attribute.
}
\description{
Compute a draw from a univariate distribution using the code provided by
Radford M. Neal. The documentation below is also reproduced from Neal (2008).
}
\note{
The log density function may return -Inf for points outside the support
of the distribution.  If a lower and/or upper bound is specified for the
support, the log density function will not be called outside such limits.
}
