% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{simulate_tlm}
\alias{simulate_tlm}
\title{Simulate a transformed linear model}
\usage{
simulate_tlm(
  n,
  p,
  g_type = "beta",
  n_test = 1000,
  heterosked = FALSE,
  lambda = 1,
  prop_sig = 0.5
)
}
\arguments{
\item{n}{number of observations in the training data}

\item{p}{number of covariates}

\item{g_type}{type of transformation; must be one of
\code{beta}, \code{step}, or \code{box-cox}}

\item{n_test}{number of observations in the testing data}

\item{heterosked}{logical; if TRUE, simulate the latent data with heteroskedasticity}

\item{lambda}{Box-Cox parameter (only applies for \code{g_type = 'box-cox'})}

\item{prop_sig}{proportion of signals (nonzero coefficients)}
}
\value{
a list with the following elements:
\itemize{
\item \code{y}: the response variable in the training data
\item \code{X}: the covariates in the training data
\item \code{y_test}: the response variable in the testing data
\item \code{X_test}: the covariates in the testing data
\item \code{beta_true}: the true regression coefficients
\item \code{g_true}: the true transformation, evaluated at y
}
}
\description{
Generate training data (X, y) and testing data (X_test, y_test)
for a transformed linear model. The covariates are correlated
Gaussian variables. A user-specified proportion (\code{prop_sig})
of the regression coefficients are nonozero (= 1) and the rest are zero.
There are multiple options for the transformation, which define the support
of the data (see below).
}
\details{
The transformations vary in complexity and support
for the observed data, and include the following options:
\code{beta} yields marginally Beta(0.1, 0.5) data
supported on [0,1]; \code{step} generates a locally-linear
inverse transformation and produces positive data; and \code{box-cox}
refers to the signed Box-Cox family indexed by \code{lambda},
which generates real-valued data with examples including identity,
square-root, and log transformations.
}
\note{
The design matrices \code{X} and \code{X_test}
do not include an intercept and there is no
intercept parameter in \code{beta_true}. The
location/scale of the data are not identified
in general transformed regression models, so
recovering them is not a goal.
}
\examples{
# Simulate data:
dat = simulate_tlm(n = 100, p = 5, g_type = 'beta')
names(dat) # what is returned
hist(dat$y, breaks = 25) # marginal distribution

}
