% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{transformdata}
\alias{transformdata}
\title{Transform the data with normalization and/or spline basis}
\usage{
transformdata(
  x,
  standardize = c("interval", "zscore", "none"),
  spline.knots = 0,
  spline.degree = 1
)
}
\arguments{
\item{x}{a single column of values as input for the data
transformation}

\item{standardize}{Either a string value denoting a predefined scaling, or a
list with values \code{a} and \code{b} corresponding with the numeric
centering and scaling, that is, using the function
\code{x * standardize$b - standardize$a}.}

\item{spline.knots}{Number of inner knots to use. \code{isb} will equally
distribute the knots over the value range using quantiles.
\code{spline.knots} will only be used if \code{knots} is not given.}

\item{spline.degree}{The polynomial degree of the spline basis.}
}
\value{
transformed data in spline basis or (in case of no spline)
  a normalized vector
}
\description{
Performs subsequently a normalization of the input data and
creating spline basis based on the user defined input
}
