% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood_Generalized.R
\name{log_likelihood_Generalized}
\alias{log_likelihood_Generalized}
\title{Compute Log-Likelihood for a Generalized Dynamic Copula-GEV Model}
\usage{
log_likelihood_Generalized(params, U, Z, X, copula)
}
\arguments{
\item{params}{Numeric vector of model parameters, including copula parameters
(omega, alpha, gamma) and GEV distribution parameters.}

\item{U}{Numeric matrix (n_train x D), pseudo-observations for the copula.}

\item{Z}{Numeric array (n_train x D x M), observed data for each margin and sub-feature.}

\item{X}{Numeric matrix (n_train x M), risk factors for the dynamic copula parameter.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank",
"Gumbel", "Joe", or "Gaussian".}
}
\value{
Numeric, negative log-likelihood value.
}
\description{
Computes the log-likelihood for a time-varying copula model combined with
Generalized Extreme Value (GEV) margins.
}
\examples{
test_ll <- log_likelihood_Generalized(init_params_full_G,uu,
                      zz_train,xx_train,"Gaussian")

}
