% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_table_save.R
\name{od_table_save}
\alias{od_table_save}
\alias{od_table_local}
\title{Saves/load opendata datasets via tar archives}
\usage{
od_table_save(x, file = NULL)

od_table_local(file)
}
\arguments{
\item{x}{an object of class \code{od_table}}

\item{file}{An archive file file for the dataset. For \code{od_table_save()},
the default is \verb{\{id\}.tar.gz} where \code{id} denotes the OGD identifier.}
}
\value{
\itemize{
\item for \code{\link[=od_table_save]{od_table_save()}}: the path to the generated file
\item for \code{\link[=od_table_local]{od_table_local()}}: the OGD identifier
}
}
\description{
\code{od_table_save()} creates a tar archive containing all relevant data from the
OGD portal. \code{od_table_local()} parses the tar archive and recreates the
\code{od_table} object.
}
\examples{
x <- od_table("OGD_krebs_ext_KREBS_1")

# save dataset as an archive
archive <- file.path(tempdir(), "table.tar.gz")
od_table_save(x, archive)

# read the saved archive
x2 <- od_table_local(archive)

# cleanup
file.remove(archive)
}
