% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_table.R
\name{od_table_class}
\alias{od_table_class}
\title{Create a table-instance from an open-data dataset}
\description{
R6 Class open data datasets.
}
\keyword{internal}
\section{Super class}{
\code{\link[STATcubeR:sc_data]{STATcubeR::sc_data}} -> \code{od_table}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{json}}{parsed version of \verb{https://data.statistik.gv.at/ogd/json?dataset=$\{id\}}}

\item{\code{header}}{parsed version of \verb{https://data.statistik.gv.at/data/$\{id\}_HEADER.csv}.

Similar contents can be found in \verb{$meta}.}

\item{\code{resources}}{lists all files downloaded from the server to construct this table}

\item{\code{od_server}}{The server used for initialization (see to \code{?od_table})}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-od_table-new}{\code{od_table_class$new()}}
\item \href{#method-od_table-browse}{\code{od_table_class$browse()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="STATcubeR" data-topic="sc_data" data-id="field"><a href='../../STATcubeR/html/sc_data.html#method-sc_data-field'><code>STATcubeR::sc_data$field()</code></a></span></li>
<li><span class="pkg-link" data-pkg="STATcubeR" data-topic="sc_data" data-id="tabulate"><a href='../../STATcubeR/html/sc_data.html#method-sc_data-tabulate'><code>STATcubeR::sc_data$tabulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="STATcubeR" data-topic="sc_data" data-id="total_codes"><a href='../../STATcubeR/html/sc_data.html#method-sc_data-total_codes'><code>STATcubeR::sc_data$total_codes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-od_table-new"></a>}}
\if{latex}{\out{\hypertarget{method-od_table-new}{}}}
\subsection{Method \code{new()}}{
This class is not exported. Use \code{\link[=od_table]{od_table()}} to
initialize objects of class \code{od_table}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{od_table_class$new(id, language = NULL, server = "ext")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{the id of the dataset that should be accessed}

\item{\code{language}}{language to be used for labeling. \code{"en"} or \code{"de"}}

\item{\code{server}}{the OGD-Server server to be used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-od_table-browse"></a>}}
\if{latex}{\out{\hypertarget{method-od_table-browse}{}}}
\subsection{Method \code{browse()}}{
open the metadata for the dataset in a browser
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{od_table_class$browse()}\if{html}{\out{</div>}}
}

}
}
