% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_list.R
\name{od_catalogue}
\alias{od_catalogue}
\title{Get a catalogue for OGD datasets}
\usage{
od_catalogue(server = "ext", local = TRUE)
}
\arguments{
\item{server}{the OGD-server to be used. \code{"ext"} (the default) for the
external server or \code{prod} for the production server}

\item{local}{If \code{TRUE} (the default), the catalogue is created based on
cached json metadata. Otherwise, the cache is updated prior to
creating the catalogue using a "bulk-download" for metadata files.}
}
\value{
a \code{data.frame} with the following structure\tabular{lll}{
   \strong{Column} \tab \strong{Type} \tab \strong{Description} \cr
   title \tab \code{chr} \tab Title of the dataset \cr
   measures \tab \code{int} \tab Number of measure variables \cr
   fields \tab \code{int} \tab Number of classification fields \cr
   modified \tab \code{datetime} \tab Timestamp when the dataset was last modified \cr
   created \tab \code{datetime} \tab Timestamp when the dataset was created \cr
   database \tab \code{chr} \tab ID of the corresponding STATcube database \cr
   title_en \tab \code{chr} \tab English title \cr
   notes \tab \code{chr} \tab Description for the dataset \cr
   frequency \tab \code{chr} \tab How often is the dataset updated? \cr
   category \tab \code{chr} \tab Category of the dataset \cr
   tags \tab \verb{list<chr>} \tab tags assigned to the dataset \cr
   json \tab \verb{list<od_json>} \tab Full json metadata \cr
}


The type \code{datetime} refers to the \code{POSIXct} format as returned by \code{\link[=Sys.time]{Sys.time()}}.
The last column \code{"json"} contains the full json metadata as returned by
\code{\link[=od_json]{od_json()}}.
}
\description{
\strong{EXPERIMENTAL} This function parses several json metadata files at once
and combines them into a \code{data.frame} so the datasets can easily be
filtered based on categorizations, tags, number of classifications, etc.
}
\details{
The naming, ordering and choice of the columns is likely to change.
}
\examples{
catalogue <- od_catalogue()
catalogue
table(catalogue$update_frequency)
table(catalogue$categorization)
catalogue[catalogue$categorization == "Gesundheit", 1:4]
catalogue[catalogue$measures >= 70, 1:3]
catalogue$json[[1]]
head(catalogue$database)
}
