% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack_theta.R
\name{pack_theta}
\alias{pack_theta}
\title{Pack FMM Parameters into a Vector}
\usage{
pack_theta(pi_k, mu_k, Sigma, g, p, ncov = 1)
}
\arguments{
\item{pi_k}{Numeric vector of length g with mixture weights (positive, sum to 1).}

\item{mu_k}{List of length g; each element a numeric vector of length p (component means).}

\item{Sigma}{Covariance: if \code{ncov = 1}, a single p x p matrix;
if \code{ncov = 2}, a list of g p x p matrices.}

\item{g}{Integer: number of components.}

\item{p}{Integer: dimension.}

\item{ncov}{Integer: covariance structure; 1 for shared covariance, 2 for class-specific.}
}
\value{
Numeric vector with parameters packed.
}
\description{
Packs mixture weights, means, and covariance(s) into a single numeric vector.
Uses the last component as the baseline for mixture weights (g-1 logits stored).
}
