% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_example_data}
\alias{generate_example_data}
\title{Generate Example Data for SQUIRE}
\usage{
generate_example_data(n_time = 8, n_rep = 4, seed = NULL)
}
\arguments{
\item{n_time}{Number of time points (default 8)}

\item{n_rep}{Number of replicates per treatment (default 4)}

\item{seed}{Random seed for reproducibility (default NULL)}
}
\value{
A data frame with columns: time, treatment, replicate, response
}
\description{
Creates a simple example dataset suitable for testing SQUIRE functionality.
The data simulates a germination experiment with three treatments.
}
\examples{
# Generate example data
example_data <- generate_example_data(seed = 123)
head(example_data)

# Check structure
str(example_data)
table(example_data$treatment, example_data$time)

}
