% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSaggreg.R
\name{TSaggreg}
\alias{TSaggreg}
\title{Aggregates daily rainfall totals at quasi-week time scales}
\usage{
TSaggreg(daily.rain, start.date, TS = 4L)
}
\arguments{
\item{daily.rain}{Vector, 1-column matrix or data frame with daily rainfall totals.}

\item{start.date}{Date at which the aggregation should start. Preferred formats are
\dQuote{YYYY-MM-DD}, \dQuote{YYYY/MM/DD} but most any valid date format
should work.}

\item{TS}{Time scale on the quasiWeek basis (integer values between 1 and 96).
Default is 4, which corresponds to the monthly time scale.}
}
\value{
A matrix with rainfall amounts aggregated at the time scale selected by
the user
}
\description{
Aggregates daily rainfall totals at quasi-week time scales
}
\details{
This package adopts a quasi-weekly time step, dividing each month into four fixed periods:
days 1–7, 8–14, 15–21, and 22 through the end of the month. This approach ensures a
consistent total of 48 quasi-weekly intervals per year, regardless of the selected
aggregation time scale (\code{TS}).
For instance, when \code{TS = 4} (representing a one-month backward-looking window), the
function computes cumulative precipitation totals over four consecutive quasi-weekly
periods. This aggregation is repeated across all 48 periods of each year, generating
a time series of aggregated precipitation values suitable for subsequent SPI estimation.
}
\examples{

daily.rain <- CampinasRain[,2]
rainTS4 <- TSaggreg(daily.rain=daily.rain,start.date="1980-01-01",TS=4)
}
