% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSaturated.R
\name{createSaturated}
\alias{createSaturated}
\title{Function to create a regular saturated strength 2 array}
\usage{
createSaturated(s, k = 2)
}
\arguments{
\item{s}{the prime or prime power to use}

\item{k}{integer; determines the run size: the resulting array will have s^k runs}
}
\value{
\code{createSaturated} returns an s^k times (s^k-1)/(s-1) matrix (saturated regular OA with s-level columns)
}
\description{
produces an OA(s^k, (s^k-1)/(s-1), s, 2) (Rao-Hamming construction)
}
\details{
For many situations, the saturated fractions produced by this function are not the best choice
for direct use in experimentation, because they heavily confound main effects with interactions.\cr
If not all columns are needed, using the last m columns may yield better results
than using the first m columns.\cr
If possible, stronger OAs from other sources can be used,
e.g. from package \pkg{\link[FrF2]{FrF2}} for 2-level factors or from package \pkg{\link[DoE.base]{DoE.base}} for
factors with more than 2 levels.
}
\examples{
createSaturated(3, k=3)  ## 27 x 13 array in 3 levels
}
