% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_qc_app.R
\name{run_qc_app}
\alias{run_qc_app}
\title{Launch the SHARK4R Bio-QC Tool}
\usage{
run_qc_app(interactive = TRUE)
}
\arguments{
\item{interactive}{Logical value whether the session is interactive or not.}
}
\value{
This function is called for its side effect of launching a Shiny application.
It does not return a value.
}
\description{
This function launches the interactive Shiny application for performing
quality control (QC) on SHARK data. The application provides a graphical
interface for exploring and validating data before or after submission to SHARK.
}
\details{
The function checks that all required packages for the app are installed
before launching. If any are missing, the user is notified. In interactive
sessions, the function will prompt whether the missing packages should be
installed automatically. In non-interactive sessions (e.g. scripts or CI),
the function instead raises an error and lists the missing packages so they
can be installed manually.
}
\examples{
\donttest{
# Launch the SHARK4R Bio-QC Tool
if(interactive()){
  run_qc_app()
}
}

}
