% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nua_api_functions.R
\name{get_nua_harmfulness}
\alias{get_nua_harmfulness}
\title{Retrieve harmfulness for taxa from Nordic Microalgae}
\usage{
get_nua_harmfulness(slug, verbose = TRUE)
}
\arguments{
\item{slug}{A vector of taxon slugs (identifiers) for which to retrieve external links.}

\item{verbose}{A logical flag indicating whether to display a progress bar. Default is \code{TRUE}.}
}
\value{
A \code{tibble} containing the following columns:
\item{slug}{The slug (identifier) of the taxon.}
\item{provider}{The provider of the external link.}
\item{label}{The label of the external link.}
\item{external_id}{The external ID associated with the external link.}
\item{external_url}{The URL of the external link.}
\item{collection}{The collection category, which is "Harmful algae blooms" for all rows.}
}
\description{
This function retrieves harmfulness information related to algae taxa from the Nordic Microalgae API.
It takes a vector of slugs (taxon identifiers) and returns a data frame containing the harmfulness information
associated with each taxon. The data includes the provider, label, external ID, and the URL of the external link.
}
\details{
The slugs (taxon identifiers) used in this function can be retrieved using the \code{get_nua_taxa()} function,
which returns a data frame with a column for taxon slugs, along with other relevant metadata for each taxon.
}
\examples{
\donttest{
  # Retrieve external links for a vector of slugs
  harmfulness <- get_nua_harmfulness(slug = c("dinophysis-acuta",
                                              "alexandrium-ostenfeldii"),
                                     verbose = FALSE)
  print(harmfulness)
}
}
\seealso{
\url{https://nordicmicroalgae.org/} for Nordic Microalgae website.

\url{https://nordicmicroalgae.org/api/} for Nordic Microalgae API documentation.
}
