% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{get_dyntaxa_records}
\alias{get_dyntaxa_records}
\title{Get taxonomic information from Dyntaxa for specified taxon IDs}
\usage{
get_dyntaxa_records(taxon_ids, subscription_key = Sys.getenv("DYNTAXA_KEY"))
}
\arguments{
\item{taxon_ids}{A vector of numeric taxon IDs (Dyntaxa ID) for which taxonomic information is requested.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{get_dyntaxa_records(238366, subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}
}
\value{
A \code{tibble} containing taxonomic information for the specified taxon IDs.
Columns include \code{taxonId}, \code{names}, \code{category}, \code{rank}, \code{isRecommended}, and \code{parentTaxonId.}
}
\description{
This function queries the SLU Artdatabanken API (Dyntaxa) to retrieve taxonomic information for the specified taxon IDs.
It constructs a request with the provided taxon IDs, sends the request to the SLU Artdatabanken API, and
processes the response to return taxonomic information in a data frame.
}
\details{
A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}

\strong{Note}: Please review the \href{https://www.slu.se/artdatabanken/rapportering-och-fynd/oppna-data-och-apier/}{API conditions}
and \href{https://api-portal.artdatabanken.se/}{register for access} before using the API. Data collected through the API
is stored at SLU Artdatabanken. Please also note that the authors of \code{SHARK4R} are not affiliated with SLU Artdatabanken.
}
\examples{
\dontrun{
# Get taxonomic information for taxon IDs 238366 and 1010380
taxon_info <- get_dyntaxa_records(c(238366, 1010380), "your_subscription_key")
print(taxon_info)
}


}
\seealso{
\href{https://api-portal.artdatabanken.se/}{SLU Artdatabanken API Documentation}
}
