% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAKTI.R
\name{LnKd}
\alias{LnKd}
\title{Dimensionless Distribution Coefficient}
\usage{
LnKd(V, m, MW.Ad, M.Ad, Non_T_trt, T_trt, Rep, IGC, Ce)
}
\arguments{
\item{V}{Volumn of water in litre}

\item{m}{Mass of the adsorbent in gram}

\item{MW.Ad}{Molar weight of the adsorbate in gram per mole}

\item{M.Ad}{Molarity of the solvent in mole per litre(55.5 for water)}

\item{Non_T_trt}{Non-temperature treatment}

\item{T_trt}{Temperature treatment}

\item{Rep}{Replication}

\item{IGC}{Initial graded concentrations of the adsorbate in milligram per litre}

\item{Ce}{Equilibrium concentration of the adsorbate in milligram per litre}
}
\value{
\itemize{
  \item qe_i: Absorbed amount in milligram per kg
  \item Kd_i: Distribution coefficient
  \item lnKd_i: Natural logarithm of Kd
  \item Mean_lnkd: Average of lnKd
}
}
\description{
This function computes the natural logarithm of dimensionless distribution coefficient (Kd) from adsorption equilibrium data across temperatures, and non-temperature treatments, if any. This function prepares the foundational input required for thermodynamic parameter analysis.
}
\examples{
V <- 0.02  # in litre
m <- 2 # in gram
MW.Ad <- 75
M.Ad <- 55.5
Non_T_trt <- c(0,0,0,0,0,0,1,1,1,1,1,1)
T_trt <- c(1,1,1,2,2,2,1,1,1,2,2,2)
Rep <- c(1,2,3,1,2,3,1,2,3,1,2,3)
IGC <- c(2,4)
Ce2 <- c(0.030, 0.031, 0.032, 0.033, 0.034, 0.035, 0.030, 0.031, 0.032, 0.033, 0.034, 0.035)
Ce4 <- c(0.030, 0.031, 0.032, 0.033, 0.034, 0.035, 0.030, 0.031, 0.032, 0.033, 0.034, 0.035)
Ce <- data.frame(Ce2, Ce4)
my.LnKd<- LnKd(V, m, MW.Ad, M.Ad, Non_T_trt, T_trt, Rep, IGC, Ce)
}
\references{
Roy, A., Manjaiah, K. M., Datta, S. P., Rakshit, D., Barman, M., Ray, P., Golui, D., Raza, M. B., Tigga, P., Mondal, S., Vishwanath, Meena, S., & Meena, P. (2025). Effect of Low-Molecular-Weight Organic Acids and Silicon on Arsenic Adsorption and Desorption in a Paddy Soil of Bengal Delta Plain: Insights from Thermodynamics and Equilibrium Modeling. Water, Air, & Soil Pollution, 236(6), 344. https://doi.org/10.1007/s11270-025-07963-7
}
