% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test61.R
\name{Test61}
\alias{Test61}
\title{Finding case deletions required to change fit metric using exact influences}
\usage{
Test61(
  df,
  model,
  threshold,
  fit,
  max_final,
  N,
  measureTest = "cfi",
  fitThreshold = 0.9,
  highGood = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{threshold}{The threshold for percentage of data dropped.}

\item{fit}{The SEM object.}

\item{max_final}{The maximum number of influential data points to consider.}

\item{N}{The total number of data points.}

\item{measureTest}{The fit measurement name. Can be "cfi", "chisq", "tli", "rmsea".}

\item{fitThreshold}{The threshold of the fit measurement to be a "good" model. For example, for CFI (measureTest = "cfi), this threshold can be 0.9.}

\item{highGood}{A boolean argument stating if the fit measurement is higher the better. For CFI, this argument is TRUE.}

\item{...}{Other arguments.}
}
\value{
A list of class \code{TestResult61} containing:
\item{methodname}{The name of the method used.}
\item{testindex}{The index of the test performed.}
\item{original_fit_value}{The original value of the fit measurement.}
\item{final_fit_value}{The fit value after dropping the influential points.}
\item{num_drops}{The number of data points dropped.}
\item{threshold_crossed}{Logical indicating whether the threshold was crossed.}
\item{final_drops}{The indices of the most influential data points dropped.}
\item{measureTest}{The name of the fit measurement used.}
\item{fitThreshold}{The threshold of the fit measurement used.}
\item{highGood}{Logical indicating if a higher value is better for the fit measurement.}
\item{exact_threshold_tally}{The tally value required to cross the threshold.}
\item{model_exact_threshold_final}{The final fit value after dropping points sufficient to cross the threshold.}
\item{max_final}{The maximum number of influential data points to consider.}
\item{N}{The total number of data points.}
}
\description{
Remove a fixed percentage of samples (determined by the exact influence) at a time and refit the model to observe the change in the path of interest. Use method 1 - Naive Method with Exact Influence.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)
library(R.utils)


# Import data
df <- PoliticalDemocracy

# Build Model
model <- '
  # measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  # regressions
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  # residual correlations
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

threshold <- 10

# Fit SEM model
fit <- lavaan::sem(model, data = df)
summary(fit)

# Compute max number of points to be dropped
max_final <- ceiling(threshold * nrow(df) / 100)
N <- nrow(df)

Test61_result <- Test61(df, model, threshold, fit, max_final, N,
 measureTest = "cfi", fitThreshold = 0.9, highGood = TRUE)
summary(Test61_result)
}
}
