SUBROUTINE safe_fista(x, y, k, nobs, nvars, &
  & nlam, ulam, eps, eps2, gamma, beta, alpha, maxit, npass_beta, &
  & npass_gamma, int_b, int_g, ind_p, jerr)
! --------------------------------------------------
  IMPLICIT NONE
  ! - - - arg types - - -
  INTEGER :: nobs, nvars, nlam, maxit, jerr
  INTEGER :: npass_beta(nlam), k(nobs), ind_p (nvars)
  INTEGER :: npass_gamma(nlam)
  DOUBLE PRECISION :: eps, x (nobs, nvars), y (nobs)
  DOUBLE PRECISION :: ulam (nlam), eps2
  DOUBLE PRECISION :: gamma (nvars, nlam)
  DOUBLE PRECISION :: beta (nvars, nlam), alpha
  DOUBLE PRECISION :: int_b (nvars), int_g (nvars)
  ! - - - local declarations - - -
  INTEGER :: i, j, n, l, indvec(nvars)
  DOUBLE PRECISION :: told, tnew, mul = 1.0D0, nold, nnew
  DOUBLE PRECISION :: dms, lms, rnobs
  DOUBLE PRECISION :: betanew (nvars), gammanew (nvars)
  DOUBLE PRECISION :: betavec (nvars), gammavec (nvars)
  DOUBLE PRECISION :: zvec (nvars), hold (nobs), hnew (nobs)
  DOUBLE PRECISION :: rvec (nvars), gold (nobs), gnew (nobs)
  DOUBLE PRECISION :: xibeta, wvec (nvars), vvec (nvars)
  DOUBLE PRECISION :: xigamma, difbeta (nvars), difgam (nvars)
  DOUBLE PRECISION :: oldbeta (nvars), oldz (nvars), olddif(nvars)
  DOUBLE PRECISION :: oldgamma (nvars), oldr (nvars), oldgamdif(nvars)
  DOUBLE PRECISION :: ar, aval, cr, cval, bound, eta
  DOUBLE PRECISION :: kkt_gamma (nvars), d_gamma (nvars), kkt_tmp
  DOUBLE PRECISION :: mle_gam(nobs), obj_gam, mle_beta(nobs), obj_beta
  DOUBLE PRECISION :: betagam(nvars)
  gamma = 0.0D0
  beta = 0.0D0
  betavec = int_b
  gammavec = int_g
  oldbeta = int_b
  oldgamma = int_g
  zvec = 0.0D0
  rvec = 0.0D0
  hold = 0.0D0
  hnew = 0.0D0
  gold = 0.0D0
  gnew = 0.0D0
  xibeta = 0.0D0
  xigamma = 0.0D0
  rnobs = Real(nobs)
  npass_beta = 0
  npass_gamma = 0
  jerr = 0
  mle_beta = 0.0D0
  mle_gam = 0.0D0
  betagam = 0.0D0
  olddif = 0.0D0
  lambda_loop: DO l = 1, nlam
    betavec = int_b
    gammavec = int_g
    oldbeta = int_b
    oldgamma = int_g
    oldz = 0.0D0
    DO i = 1, nobs
        xibeta = Dot_product(x(i, :), oldbeta)
        oldz(:) = oldz(:) + x(i, :) * exp(xibeta) - k(i) * x(i, :) 
    ENDDO
    oldz = oldz / rnobs
    oldr = 0.0D0
    DO i = 1, nobs
      xigamma = Dot_product(x(i, :), oldgamma)
      oldr(:) = oldr(:) - y(i) * alpha * x(i, :) * exp(-xigamma) &
                 & + k(i) * x(i, :) * alpha
    ENDDO 
    oldr = oldr / rnobs
    told = 1.0D0
    eta = 0.5 !?
    !!!xk
    update_beta: DO 
      zvec = 0.0D0          
      DO i = 1, nobs
        xibeta = Dot_product(x(i, :), betavec)
        zvec(:) = zvec(:) + x(i, :) * exp(xibeta) - k(i) * x(i, :) 
        hold(i) = exp(xibeta) - k(i) * xibeta
      ENDDO 
      zvec = zvec / rnobs
      hold = hold / rnobs
      n = 1
      IF ( Dot_product(olddif, olddif) == 0.0D0) THEN
        ar = 0.0D0
      ELSE
        ar = Dot_product(olddif, olddif) / Dot_product(olddif, zvec - oldz)
      ENDIF
      aval = 100 / (sqrt(Dot_product(zvec, zvec))) !constant
      ar = Max(ar, aval)
      line_search: DO 
        lms = (eta ** n) * ar
        wvec = betavec - lms * zvec
        DO j = 1, nvars
          IF (gammavec(j) * wvec(j) > 0.0D0) THEN
            indvec(j) = 0
          ELSE
            indvec(j) = 1
          ENDIF
        ENDDO
        vvec = abs(wvec) - ind_p * lms * ulam(l) * abs(gammavec) * indvec
        DO j = 1, nvars
          IF (vvec(j) > 0.0D0) THEN
            betanew(j) = Sign(vvec(j), wvec(j))
          ELSE
            betanew(j) = 0.0D0
          ENDIF
        ENDDO
        DO i = 1, nobs
          xibeta = Dot_product(x(i, :), betanew)
          hnew(i) = exp(xibeta) - k(i) * xibeta
        ENDDO 
        hnew = hnew / rnobs
        difbeta = betanew-betavec
        bound = Sum(hold) + Dot_product(difbeta, zvec) + &
                & 0.5D0 * (1.0D0 / lms) * Sum(difbeta ** 2)
        bound = Sum(hnew) - bound 
        IF (bound > 0.0D0) THEN
          n = n + 1
        ELSE
          EXIT
        ENDIF
      ENDDO line_search

      tnew = 0.5 + 0.5 * Sqrt(1.0 + 4.0 * told * told)
      mul = 1.0 + (told - 1.0) / tnew
      told = tnew
      oldbeta = betavec
      oldz = zvec
      betavec = betavec + mul * difbeta
      difbeta = betavec - oldbeta
      obj_beta = 0.0D0
      DO i = 1, nobs
        xibeta = Dot_product(x(i, :), betavec)
        mle_beta(i) = exp(xibeta) - k(i) * xibeta
      ENDDO 
      obj_beta = sum(mle_beta) / rnobs 
      DO j = 1, nvars
        betagam(j) = max(-betavec(j)*gammavec(j),0.0D0)
      ENDDO
      obj_beta = obj_beta + ulam(l)*sum(betagam)
      npass_beta(l) = npass_beta(l) + 1
      IF (Maxval(difbeta * difbeta) < eps * mul * mul) EXIT
      IF (Sum(npass_beta) > maxit) EXIT
    ENDDO update_beta
    beta(:, l) = betavec
    IF (Sum(npass_beta) > maxit) EXIT
! -------------------------------------------- gamma loop
    nold = 1.0D0
    update_gamma: DO 
      rvec = 0.0D0
      kkt_gamma = 0.0D0
      DO i = 1, nobs
        xigamma = Dot_product(x(i, :), gammavec)
        rvec(:) = rvec(:) - y(i) * alpha * x(i, :) * exp(-xigamma) &
                   & + k(i) * x(i, :) * alpha
        gold(i) = y(i) * alpha * exp(-xigamma) + k(i) * alpha * xigamma
      ENDDO 
      rvec = rvec / rnobs 
      gold = gold / rnobs 
      oldgamdif = gammavec - oldgamma
      IF (Dot_product(oldgamdif, oldgamdif) == 0.0D0) THEN
        cr = 0.0D0
      ELSE
        cr = Dot_product(oldgamdif, oldgamdif) / Dot_product(oldgamdif, rvec - oldr)
      ENDIF
      cval = 1 / (sqrt(Dot_product(rvec, rvec)))
      cr = Max(cr, cval)
      n = 1
      gam_line_search: DO 
        dms = (eta ** n) * cr
        wvec = gammavec - dms * rvec
        DO j = 1, nvars
          IF (betavec(j) * wvec(j) > 0.0D0) THEN
            indvec(j) = 0
          ELSE
            indvec(j) = 1
          ENDIF
        ENDDO
        vvec = abs(wvec) - ind_p * dms * ulam(l) * abs(betavec) * indvec
        DO j = 1, nvars
          IF (vvec(j) > 0.0D0) THEN
            gammanew(j) = Sign(vvec(j), wvec(j))
          ELSE
            gammanew(j) = 0.0D0
          ENDIF
        ENDDO
        DO i = 1, nobs
          xigamma = Dot_product(x(i, :), gammanew)
          gnew(i) = y(i) * alpha * exp(-xigamma) + k(i) * alpha * xigamma
        ENDDO 
        gnew = gnew / rnobs
        difgam = gammanew-gammavec
        bound = Sum(gold) + Dot_product(difgam, rvec) + &
                & 0.5D0 * (1.0D0 / dms) * Sum(difgam ** 2)
        bound = Sum(gnew) - bound 
        IF (bound > 0.0D0) THEN
          n = n + 1
        ELSE
          EXIT
        ENDIF
      ENDDO gam_line_search
      nnew = 0.5 + 0.5 * Sqrt(1.0 + 4.0 * nold * nold)
      mul = 1.0 + (nold - 1.0) / nnew
      nold = nnew
      oldgamma = gammavec
      oldr = rvec
      gammavec = gammavec + mul * difgam 
      difgam = gammavec - oldgamma
      ! kkt
      d_gamma = 0.0D0
      obj_gam = 0.0D0
      DO i = 1, nobs
          xigamma = Dot_product(x(i, :), gammavec)
          d_gamma = d_gamma  + (k(i) - y(i) * exp(-xigamma)) * alpha * x(i, :)
          mle_gam(i) = k(i) * alpha * xigamma + y(i) * alpha * exp(-xigamma) 
      ENDDO
      obj_gam = sum(mle_gam) / rnobs 
      DO j = 1, nvars
        betagam(j) = max(-betavec(j)*gammavec(j),0.0D0)
      ENDDO
      obj_gam = obj_gam + ulam(l)*sum(betagam)
      DO j = 1, nvars
          IF (betavec(j) * d_gamma(j) > 0.0D0) THEN
            indvec(j) = 0
          ELSE
            indvec(j) = 1
          ENDIF
      ENDDO
      DO j = 1, nvars
          kkt_tmp = abs(d_gamma(j)) - ind_p(j) * ulam(l) * abs(betavec(j)) * indvec(j)
          IF (abs(gammavec(j)) > 0) THEN
            kkt_gamma(j) = Sign(kkt_tmp, d_gamma(j))
          ELSE
            IF (kkt_tmp > 0) THEN
              kkt_gamma(j) = kkt_tmp
            ENDIF
          ENDIF
      ENDDO
      npass_gamma(l) = npass_gamma(l) + 1
      IF (Maxval(difgam * difgam) < eps2 * mul * mul) THEN
           EXIT
      ENDIF
      IF (Sum(npass_gamma) > maxit) EXIT
    ENDDO update_gamma
    gamma(:, l) = gammavec 
        
    IF (Sum(npass_beta) > maxit) THEN 
      jerr = l
    ENDIF
    IF (Sum(npass_gamma) > maxit) THEN
      jerr = l
    ENDIF 
  ENDDO lambda_loop
END SUBROUTINE safe_fista

