% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_maxnet.R
\name{dr_maxnet}
\alias{dr_maxnet}
\title{Density-ratio SDM estimation with Maxnet}
\usage{
dr_maxnet(
  presence_data = NULL,
  background_data = NULL,
  projection_data = NULL,
  formula = NULL,
  regmult = 1,
  regfun = maxnet.default.regularization,
  addsamplestobackground = TRUE,
  clamp = TRUE,
  verbose = FALSE,
  method,
  type = c("link", "exponential", "cloglog", "logistic"),
  object = NULL
)
}
\arguments{
\item{presence_data}{dataframe of covariates}

\item{background_data}{dataframe of covariates}

\item{projection_data}{dataframe of covariates}

\item{formula}{Maxnet formula to use. Default (NULL) will use the Maxnet default. This parameter is called "f" in the maxnet function, but is renamed here as using "t" and "f" as object names is frowned upon.}

\item{regmult}{Maxnet regularization multiplier. Default is 1.}

\item{regfun}{Maxnet regularization function. Default is the Maxnet default.}

\item{addsamplestobackground}{If TRUE (the default), any presences that aren't in the background will be added.}

\item{clamp}{If TRUE (the default), predictions will be limited to ranges seen in the training dataset.}

\item{method}{one of either "fit" or "predict"}

\item{type}{Type of response required.  Defaults to link, exponential, cloglog, and logistic.}

\item{object}{fitted object returned by a dr_... function. Only needed when method = "predict"}
}
\description{
dr_maxnet is an internal function for density-ratio estimation with Maxnet
}
\note{
The options f, regmult, regfun, and addSamplestobackground are only used when method == "predict",
the options clamp and type are only used when method == "predict". See the much better documentation for maxnet for more details.
}
\keyword{internal}
