% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{country_dictionary}
\alias{country_dictionary}
\title{Country dictionary for standardizing country names and codes}
\format{
A named list of two data frames:

\describe{

\item{\code{country_name}}{A data frame with two columns:
\describe{
\item{\code{country_name}}{Character. Lowercased and accent-stripped country
name variants (from multiple \code{rnaturalearthdata} fields such as
\emph{name}, \emph{name_long}, \emph{abbrev}, \emph{formal_en}, and alternative names in
several languages).}
\item{\code{country_suggested}}{Character. The standardized country name,
derived from the \code{name} column of \code{map_units110}, also lowercased and
accent-stripped.}
}}

\item{\code{country_code}}{A data frame with two columns:
\describe{
\item{\code{country_code}}{Character. Country codes from several systems,
including ISO-2, ISO-3, FIPS, postal codes, and others, after filtering
invalid or ambiguous codes.}
\item{\code{country_suggested}}{Character. The standardized country name
corresponding to each code.}
}}

}
}
\usage{
country_dictionary
}
\description{
\code{country_dictionary} provides a set of lookup tables used to standardize
country names and country codes in occurrence datasets.

The dictionary is built from \code{rnaturalearthdata::map_units110}
and consolidates a wide variety of country name variants (in several
languages and formats), as well as multiple coding systems, into a single
suggested standardized name.

This object is used internally by functions that clean or harmonize
country fields, ensuring that country names in occurrence datasets (e.g.,
\code{"Brasil"},\code{"brasil"}, \code{"BR"}, \code{"BRA"}, \code{"République Française"}) are all
mapped consistently to a single standardized form (\code{"brazil"}, \code{"france"},
etc.).
}
\details{
The dictionary is generated by:
\itemize{
\item extracting multiple name and code fields from
\code{rnaturalearthdata::map_units110},
\item converting names to lowercase and removing accents,
\item converting codes to uppercase,
\item removing invalid or ambiguous codes (e.g., \code{-99}, \code{"J"}, various
country mismatches),
\item and ensuring uniqueness across all entries.
}
}
\examples{
data(country_dictionary)

head(country_dictionary$country_name)
head(country_dictionary$country_code)

}
\keyword{datasets}
