% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_fastq_join.R
\name{vs_fastq_join}
\alias{vs_fastq_join}
\alias{vs_fasta_join}
\alias{vs_fastx_join}
\alias{fastq_join}
\alias{join}
\title{Join paired-end sequence reads}
\usage{
vs_fastq_join(
  fastq_input,
  reverse = NULL,
  output_format = "fastq",
  fastaout = NULL,
  fastqout = NULL,
  join_padgap = "NNNNNNNN",
  join_padgapq = "IIIIIIII",
  fasta_width = 0,
  log_file = NULL,
  threads = 1,
  vsearch_options = NULL,
  tmpdir = NULL
)
}
\arguments{
\item{fastq_input}{(Required). A FASTQ file path, a FASTQ tibble object
(forward reads), or a paired-end tibble of class \code{"pe_df"}. See
\emph{Details}.}

\item{reverse}{(Optional). A FASTQ file path or a FASTQ tibble object
(reverse reads). Optional if \code{fastq_input} is a \code{"pe_df"} object.
See \emph{Details}.}

\item{output_format}{(Optional). Desired output format of the file or tibble:
\code{"fasta"} or \code{"fastq"} (default).}

\item{fastaout}{(Optional). Name of the FASTA output file with the joined
reads. If \code{NULL} (default), no output is written to a file. See
\emph{Details}.}

\item{fastqout}{(Optional). Name of the FASTQ output file with the joined
reads. If \code{NULL} (default), no output is written to a file. See
\emph{Details}.}

\item{join_padgap}{(Optional). Padding sequence to use in the gap between the
sequences. Defaults to \code{"NNNNNNNN"}.}

\item{join_padgapq}{(Optional). Quality of the padding sequence. Defaults to
\code{"IIIIIIII"}, corresponding to a base quality score of 40 (a very high
quality score with error probability \code{0.0001}).}

\item{fasta_width}{(Optional). Number of characters per line in the output
FASTA file. Only applies if the output file is in FASTA format. Defaults to
\code{0}, which eliminates wrapping.}

\item{log_file}{(Optional). Name of the log file to capture messages from
\code{VSEARCH}. If \code{NULL} (default), no log file is created.}

\item{threads}{(Optional). Number of computational threads to be used by
\code{VSEARCH}. Defaults to \code{1}.}

\item{vsearch_options}{(Optional). Additional arguments to pass to
\code{VSEARCH}. Defaults to \code{NULL}. See \emph{Details}.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
A tibble or \code{NULL}.

If \code{fastaout} or \code{fastqout} is specified, the joined sequences are
written to the specified output file, and no tibble is returned.

If \code{fastaout} or \code{fastqout} is \code{NULL}, a tibble containing the
joined reads in the format specified by \code{output_format} is returned.
}
\description{
\code{vs_fastq_join} joins paired-end sequence reads into a
single sequence with a specified gap between them using \code{VSEARCH}.
}
\details{
Read pairs from the input FASTQ files (\code{fastq_input} and \code{reverse})
are joined into a single sequence by adding a gap with a specified padding
sequence. The resulting sequences consist of the forward read, the padding
sequence, and the reverse complement of the reverse read.

\code{fastq_input} and \code{reverse} can either be file paths to FASTQ files
or FASTQ objects. FASTQ objects are tibbles that contain the columns
\code{Header}, \code{Sequence}, and \code{Quality}, see
\code{\link[microseq]{readFastq}}. Forward and reverse reads must appear in the same
order and have the same total number of reads in both files.

If \code{fastq_input} is an object of class \code{"pe_df"}, the reverse reads
are automatically extracted from its \code{"reverse"} attribute unless
explicitly provided via the \code{reverse} argument. This simplifies function
calls when using paired-end tibbles created by functions such as
\code{\link{fastx_synchronize}} or \code{\link{vs_fastx_trim_filt}}.

If \code{fastaout} or \code{fastqout} is specified, the joined reads are
written to the respective file in either FASTA or FASTQ format.

If both \code{fastaout} or \code{fastqout} are \code{NULL}, the results are
returned as a FASTA or FASTQ object, and no file is written.
\code{output_format} must match the desired output files/objects.

Any input sequence with fewer bases than the value set in \code{minlen} is
discarded. By default, \code{minlen} is set to 0, which means that no
sequences are removed. However, using the default value may allow empty
sequences to remain in the results.

\code{vsearch_options} allows users to pass additional command-line arguments
to \code{VSEARCH} that are not directly supported by this function. Refer to
the \code{VSEARCH} manual for more details.
}
\examples{
\dontrun{
# Define arguments
fastq_input <- file.path(file.path(path.package("Rsearch"), "extdata"),
                         "small_R1.fq")
reverse <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "small_R2.fq")
output_format <- "fastq"

# Execute joining and return a FASTQ tibble
join_seqs <- vs_fastq_join(fastq_input = fastq_input,
                           reverse = reverse,
                           output_format = output_format)

# Execute joining and write joined sequences to file
vs_fastq_join(fastq_input = fastq_input,
              reverse = reverse,
              fastqout = "joined_sequences.fq",
              output_format = output_format)

}

}
\references{
\url{https://github.com/torognes/vsearch}
}
