% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_Omega}
\alias{update_Omega}
\title{Update class covariances}
\usage{
update_Omega(beta, b, z, m, n_Omega_0, V_Omega_0)
}
\arguments{
\item{beta}{[\code{matrix(nrow = P_r, ncol = N)}]\cr
The matrix of the decider-specific coefficient vectors.}

\item{b}{[\code{matrix(nrow = P_r, ncol = C)}]\cr
The matrix of class means as columns.}

\item{z}{[\code{numeric(N)}]\cr
The decider class allocations.}

\item{m}{[\code{numeric(C)}]\cr
The vector of current class frequencies.}

\item{n_Omega_0}{[\code{integer(1)}]\cr
The degrees of freedom of the Inverse Wishart prior for each \code{Omega_c}.}

\item{V_Omega_0}{[\code{matrix(P_r, P_r)}]\cr
The scale matrix of the Inverse Wishart prior for each \code{Omega_c}.}
}
\value{
A matrix of updated covariance matrices for each class in columns.
}
\description{
Update class covariances
}
\examples{
N <- 100
b <- cbind(c(0, 0), c(1, 1))
Omega <- matrix(c(1, 0.3, 0.3, 0.5, 1, -0.3, -0.3, 0.8), ncol = 2)
z <- c(rep(1, N / 2), rep(2, N / 2))
m <- as.numeric(table(z))
beta <- sapply(
  z, function(z) oeli::rmvnorm(n = 1, b[, z], matrix(Omega[, z], 2, 2))
)
update_Omega(
  beta = beta, b = b, z = z, m = m,
  n_Omega_0 = 4, V_Omega_0 = diag(2)
)

}
\keyword{gibbs_sampler}
