% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_normalization.R
\name{RprobitB_normalization}
\alias{RprobitB_normalization}
\alias{print.RprobitB_normalization}
\title{Utility normalization}
\usage{
RprobitB_normalization(
  level,
  scale = "Sigma_1,1 := 1",
  form,
  re = NULL,
  alternatives,
  base,
  ordered = FALSE
)

\method{print}{RprobitB_normalization}(x, ...)
}
\arguments{
\item{level}{[\code{character(1)}]\cr
The alternative name with respect to which utility differences are computed.
Currently, only differences with respect to the last alternative are
supported.}

\item{scale}{[\code{character(1)}]\cr
A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{form}{[\code{formula}]\cr
A model description with the structure \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{[\code{character()} | \code{NULL}]\cr
Names of covariates with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{alternatives}{[\code{character()}]\cr
The names of the choice alternatives. If not specified, the choice set is
defined by the observed choices.

If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{base}{[\code{character(1)}]\cr
The name of the base alternative for covariates that are not
alternative specific (i.e. type 2 covariates and ASCs).

Ignored and set to \code{NULL} if the model has no alternative specific
covariates (e.g. in the ordered probit model).

By default, \code{base} is the last element of \code{alternatives}.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{x}{An object of class \code{RprobitB_normalization}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{RprobitB_normalization}, which is a list of
\itemize{
\item \code{level}, a list with the elements \code{level} (the number of the
alternative specified by the input \code{level}) and \code{name} (the name of
the alternative, i.e. the input \code{level}), or alternatively
\code{NA} in the ordered probit case,
\item and \code{scale}, a list with the elements \code{parameter} (either \code{"s"} for
an element of \code{Sigma} or \code{"a"} for an element of \code{alpha}), the
parameter \code{index}, and the fixed \code{value}. If \code{parameter = "a"}, also
the \code{name} of the fixed effect.
}
}
\description{
This function creates an object of class \code{RprobitB_normalization},
which defines the utility scale and level.
}
\details{
Utility models require normalization with respect to level and scale.
\itemize{
\item For level normalization, \code{{RprobitB}} takes utility differences
with respect to one alternative. For the ordered model where only
one utility is modelled, \code{{RprobitB}} fixes the first utility
threshold to 0.
\item For scale normalization, \code{{RprobitB}} fixes one model parameter.
Per default, the first error-term variance is fixed to \code{1}.
This is specified via \code{scale = "Sigma_1,1 := 1"}.
Alternatively, any error-term variance or any non-random coefficient
can be fixed.
}
}
\keyword{internal}
