% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kimuraLength.R
\name{kimuraLength}
\alias{kimuraLength}
\title{Computation of the Kimura length}
\usage{
kimuraLength(
  skel_img,
  formula = 6,
  mask = NULL,
  strict_mask = TRUE,
  show_messages = TRUE
)
}
\arguments{
\item{skel_img}{Skeleton image (provided by the RootDetector). Can be a PNG,
i.e., an array with 3 dimensions (3 layers each containing a 2-dim. numeric
matrix with values between 0 and 1), or a 2-dim. matrix.}

\item{formula}{Integer value specifying the formula to be used (by default
6) based on Kimura et al., 1999 (see references). Available are the
following formulas, where \eqn{N_o}{N_o} denotes the number of orthogonal
and \eqn{N_d}{N_d} the number of diagonal connections (between white pixels),
and \eqn{N_{whitepx}}{N_{whitepx}} the number of white pixels in the image.
Furthermore, there are three additional formulas to simply count white,
or black, or red pixels. \cr
\itemize{
\item Formula 1: \eqn{1.1107 \cdot (N_d + N_o)}{1.1107 \* (N_d + N_o)},\cr
\item Formula 2: \eqn{\sqrt{2} \cdot N_d + N_o}{sqrt(2) \* N_d + N_o},\cr
\item Formula 3: \eqn{0.948 \cdot (\sqrt{2} \cdot N_d + N_o)}{0.948 \* (sqrt(2) \* N_d + N_o)},\cr
\item Formula 4: \eqn{\sqrt{N_d^2+ (N_d+N_o)^2}}{sqrt(N_d^2+ (N_d+N_o)^2)},\cr
\item Formula 6: \eqn{\sqrt{N_d^2+ (N_d+N_o/2)^2} + N_o/2}{sqrt(N_d^2+ (N_d+N_o/2)^2) + N_o/2},\cr
\item Formula 7: \eqn{1.1107 \cdot N_{whitepx}}{1.1107 \* N_{whitepx}}.
\item Formula 97: \eqn{N_{whitepx}}.
\item Formula 98: \eqn{N_{blackpx}}.
\item Formula 99: \eqn{N_{redpx}}.
}}

\item{mask}{2-dim. true/false-matrix with the same number of rows and columns
as \code{skel_img} (optional, default = NULL, interpreted as a matrix
consisting only of TRUEs, i.e., nothing is "removed" from the image).}

\item{strict_mask}{Specifies how strictly the mask should be applied.
Available are:\cr
\itemize{
\item TRUE (default): Connections between TRUE-pixels and neighboring
FALSE-pixels are not counted. As a result, the root length is likely to be
underestimated, especially if there are many TRUE-FALSE transitions in the
mask. \cr
\item FALSE: Connections between TRUE-pixels and neighboring
FALSE-pixels are counted. As a result, the root length is likely to be
overestimated, especially if there are many TRUE-FALSE transitions in the
mask.
}}

\item{show_messages}{Specify if messages about the counts of orthogonal and
diagonal connection counts should be depicted (default TRUE).}
}
\value{
\code{kimuraLength} Numeric value (root length estimation).
}
\description{
\code{kimuraLength} - Computes the Kimura length according to
the specified formula to estimate the root length
shown in a skeletonized black & white image of a root. \cr
Optionally, a masking layer can be specified that indicates which pixels of
the image should be considered.
}
\examples{
# This is a simple image with 2 diagonal and 1 orthogonal connections.
# With Formula 6 (default):
kimuraLength(matrix(c(
  1, 0, 0, 0,
  0, 1, 0, 0,
  0, 0, 1, 1
), ncol = 4, nrow = 3, byrow = TRUE))
# With Formula 4:
kimuraLength(
  matrix(c(
    1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 1
  ), ncol = 4, nrow = 3, byrow = TRUE),
  formula = 4
)
# With Formula 6 and a mask which makes the function ignore the right side
# of the image. If stict_mask = TRUE, only 1 diagonal connection can be
# found. If set to FALSE, i.e., relaxed mask borders, then 2 diagonal
# connections are counted.
kimuraLength(
  skel_img = matrix(c(
    1, 0, 0, 0,
    0, 1, 0, 0,
    0, 0, 1, 1
  ), ncol = 4, nrow = 3, byrow = TRUE),
  mask = matrix(
    c(
      TRUE, TRUE, FALSE, FALSE,
      TRUE, TRUE, FALSE, FALSE,
      TRUE, TRUE, FALSE, FALSE
    ),
    ncol = 4, nrow = 3,
    byrow = TRUE
  ), strict_mask = FALSE
)
}
\references{
Kimura, K., Kikuchi, S. & Yamasaki, Si. Accurate root length measurement by image analysis. Plant and Soil 216, 117–127 (1999). doi: 10.1023/A:1004778925316
}
