% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{robyn_run}
\alias{robyn_run}
\alias{print.robyn_models}
\title{Robyn Modelling Function}
\usage{
robyn_run(
  InputCollect = NULL,
  dt_hyper_fixed = NULL,
  json_file = NULL,
  ts_validation = FALSE,
  add_penalty_factor = FALSE,
  refresh = FALSE,
  seed = 123L,
  quiet = FALSE,
  cores = NULL,
  trials = 5,
  iterations = 2000,
  rssd_zero_penalty = TRUE,
  objective_weights = NULL,
  nevergrad_algo = "TwoPointsDE",
  intercept = TRUE,
  intercept_sign = "non_negative",
  lambda_control = NULL,
  outputs = FALSE,
  ...
)

\method{print}{robyn_models}(x, ...)
}
\arguments{
\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{dt_hyper_fixed}{data.frame or named list. Only provide when loading
old model results. It consumes hyperparameters from saved csv
\code{pareto_hyperparameters.csv} or JSON file to replicate a model.}

\item{json_file}{Character. JSON file to import previously exported inputs or
recreate a model. To generate this file, use \code{robyn_write()}.
If you didn't export your data in the json file as "raw_data",
\code{dt_input} must be provided; \code{dt_holidays} input is optional.}

\item{ts_validation}{Boolean. When set to \code{TRUE}, Robyn will split data
by test, train, and validation partitions to validate the time series. By
default the "train_size" range is set to \code{c(0.5, 0.8)}, but it can be
customized or set to a fixed value using the hyperparameters input. For example,
if \code{train_size = 0.7}, validation size and test size will both be 0.15
and 0.15. When \code{ts_validation = FALSE}, nrmse_train is the
objective function; when \code{ts_validation = TRUE}, nrmse_val is the objective
function.}

\item{add_penalty_factor}{Boolean. Add penalty factor hyperparameters to
glmnet's penalty.factor to be optimized by nevergrad. Use with caution, because
this feature might add too much hyperparameter space and probably requires
more iterations to converge.}

\item{refresh}{Boolean. Set to \code{TRUE} when used in \code{robyn_refresh()}.}

\item{seed}{Integer. For reproducible results when running nevergrad and
clustering. Each trial will increase the seed by 1 unit (i.e. 10 trials with
seed 1 will share 9 results with 10 trials with seed 2).}

\item{quiet}{Boolean. Keep messages off?}

\item{cores}{Integer. Default to \code{parallel::detectCores() - 1} (all cores
except one). Set to 1 if you want to turn parallel computing off.}

\item{trials}{Integer. Recommended 5 for default
\code{nevergrad_algo = "TwoPointsDE"}.}

\item{iterations}{Integer. Recommended 2000 for default when using
\code{nevergrad_algo = "TwoPointsDE"}.}

\item{rssd_zero_penalty}{Boolean. When TRUE, the objective function
DECOMP.RSSD will penalize models with more 0 media effects additionally.
In other words, given the same DECOMP.RSSD score, a model with 50\% 0-coef
variables will get penalized by DECOMP.RSSD * 1.5 (larger error), while
another model with no 0-coef variables gets un-penalized with DECOMP.RSSD * 1.}

\item{objective_weights}{Numeric vector. Default to NULL to give equal weights
to all objective functions. Order: NRMSE, DECOMP.RSSD, MAPE (when calibration
data is provided). When you are not calibrating, only the first 2 values for
\code{objective_weights} must be defined, i.e. set c(2, 1) to give double weight
to the 1st (NRMSE). This is an experimental feature. There's no research on
optimal weight setting. Subjective weights might strongly bias modeling results.}

\item{nevergrad_algo}{Character. Default to "TwoPointsDE". Options are
\code{c("DE","TwoPointsDE", "OnePlusOne", "DoubleFastGADiscreteOnePlusOne",
"DiscreteOnePlusOne", "PortfolioDiscreteOnePlusOne", "NaiveTBPSA",
"cGA", "RandomSearch")}.}

\item{intercept}{Boolean. Should intercept(s) be fitted (default=TRUE) or
set to zero (FALSE).}

\item{intercept_sign}{Character. Choose one of "non_negative" (default) or
"unconstrained". By default, if intercept is negative, Robyn will drop intercept
and refit the model. Consider changing intercept_sign to "unconstrained" when
there are \code{context_vars} with large positive values.}

\item{lambda_control}{Deprecated in v3.6.0.}

\item{outputs}{Boolean. If set to TRUE, will run \code{robyn_run()} and
\code{robyn_outputs()}, returning a list with OutputModels and
OutputCollect results.}

\item{...}{Additional parameters passed to \code{robyn_outputs()}.}

\item{x}{\code{robyn_models()} output.}
}
\value{
List. Class: \code{robyn_models}. Contains the results of all trials
and iterations modeled.

List. Contains all trained models. Class: \code{robyn_models}.
}
\description{
\code{robyn_run()} consumes \code{robyn_input()} outputs,
runs \code{robyn_mmm()}, and collects all modeling results.
}
\examples{
\dontrun{
# Having InputCollect results
OutputModels <- robyn_run(
  InputCollect = InputCollect,
  cores = 2,
  iterations = 200,
  trials = 1
)
}
}
