% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robFScore.R
\name{robFScore}
\alias{robFScore}
\title{Robust F-Beta Score}
\usage{
robFScore(
  actual = NULL,
  predicted = NULL,
  TP = NULL,
  FN = NULL,
  FP = NULL,
  TN = NULL,
  beta = 1,
  d0 = 0.1
)
}
\arguments{
\item{actual}{A vector of actual values (1/0 or TRUE/FALSE)}

\item{predicted}{A vector of prediction values (1/0 or TRUE/FALSE)}

\item{TP}{Count of true positives (correctly predicted 1/TRUE)}

\item{FN}{Count of false negatives (predicted 0/FALSE, but actually 1/TRUE)}

\item{FP}{Count of false positives (predicted 1/TRUE, but actually 0/FALSE)}

\item{TN}{Count of true negatives (correctly predicted 0/FALSE)}

\item{beta}{Beta squared is the weight of recall in the harmonic mean}

\item{d0}{Weight of the estimated true positive probability in the harmonic mean}
}
\value{
robust F-Beta Score.
}
\description{
Compute a robust version of the F-Beta Score.
}
\details{
Calculate the robust F-Beta Score \eqn{F_{\beta,d_0}} with two parameters.
Provide either:
\itemize{
\item \code{actual} and \code{predicted} or
\item \code{TP}, \code{FN}, \code{FP} and \code{TN}.
}

If \eqn{d_0=0}, the robust F-Beta Score coincides with the F-Beta Score.
}
\examples{
actual <-    c(1,1,1,1,1,1,0,0,0,0)
predicted <- c(1,1,1,1,0,0,1,0,0,0)
robFScore(actual, predicted, beta=1, d0=0.1)
robFScore(TP=4, FN=2, FP=1, TN=3, beta=1, d0=1)

}
\references{
Holzmann, H., Klar, B. (2024). Robust performance metrics for imbalanced classification problems.
arXiv:2404.07661. \href{https://arxiv.org/abs/2404.07661}{LINK}
}
