% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{h_unbiased_means_across_strata}
\alias{h_unbiased_means_across_strata}
\title{Check Unbiased Means of Residuals Across Randomization Strata and Treatment Groups}
\usage{
h_unbiased_means_across_strata(
  residuals_per_group,
  df,
  randomization_strata,
  eps = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{residuals_per_group}{(\code{list} of \code{numeric}) A named list of numeric vectors containing residuals for each
of the two treatment groups.}

\item{df}{(\code{data.frame}) The data frame containing the \code{treatment} and randomization strata variables, produced by
\code{\link[=h_derived_outcome_vals]{h_derived_outcome_vals()}} or \code{\link[=h_strat_derived_outcome_vals]{h_strat_derived_outcome_vals()}}.}

\item{randomization_strata}{(\code{character}) A character vector of names of the randomization strata variables
in \code{df}.}

\item{eps}{(\code{numeric}) A small tolerance value to determine if means are close to zero.}
}
\value{
\code{TRUE} if the means of residuals across randomization strata are within the specified tolerance
for both treatment groups, \code{FALSE} otherwise.
}
\description{
This function checks whether the means of residuals are approximately zero
across specified randomization strata for each of the two treatment groups.
It is used in \code{\link[=robin_surv]{robin_surv()}} downstream functions to verify the correct inclusion of randomization strata
variables in the analysis survival model.
}
\seealso{
\code{\link[=bias]{bias()}} for the underlying bias (means of residuals) calculation.
}
\keyword{internal}
