% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{h_lr_test_via_score}
\alias{h_lr_test_via_score}
\title{Log-Rank Test via Score Function}
\usage{
h_lr_test_via_score(score_fun, ...)
}
\arguments{
\item{score_fun}{(\code{function}) The log-rank score function to be used for testing.}

\item{...}{Additional arguments passed to \code{score_fun}.}
}
\value{
A list containing:
\itemize{
\item \code{u_l}: The log-rank score statistic.
\item \code{sigma_l2}: The variance of the log-rank statistic.
\item \code{tau_l}: The log-rank test statistic.
\item \code{pval}: The two-sided p-value of the log-rank test.
\item \code{n}: The number of observations used in the calculation.
}
}
\description{
This function performs a log-rank test using the score function.
}
\details{
This activates the ties factor correction in the score function by passing
\code{use_ties_factor = TRUE} to the \code{score_fun}.
}
\keyword{internal}
