% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_models}
\alias{plot_models}
\title{Models plot for a RoBSA object}
\usage{
plot_models(
  x,
  parameter = NULL,
  conditional = FALSE,
  plot_type = "base",
  order = "decreasing",
  order_by = "model",
  ...
)
}
\arguments{
\item{x}{a fitted RoBSA object}

\item{parameter}{a name of parameter to be plotted. Defaults to
the first regression parameter if left unspecified.}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{order}{how the models should be ordered.
Defaults to \code{"decreasing"} which orders them in decreasing
order in accordance to \code{order_by} argument. The alternative is
\code{"increasing"}.}

\item{order_by}{what feature should be use to order the models.
Defaults to \code{"model"} which orders the models according to
their number. The alternatives are \code{"estimate"} (for the effect
size estimates), \code{"probability"} (for the posterior model probability),
and \code{"BF"} (for the inclusion Bayes factor).}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot_models} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{plot_models} plots individual models'
estimates for a \code{"RoBSA"} object.
}
\examples{
\dontrun{
# (execution of the example takes several minutes)
# example from the README (more details and explanation therein)
data(cancer, package = "survival")
priors <- calibrate_quartiles(median_t = 5, iq_range_t = 10, prior_sd = 0.5)
df <- data.frame(
  time         = veteran$time / 12,
  status       = veteran$status,
  treatment    = factor(ifelse(veteran$trt == 1, "standard", "new"), levels = c("standard", "new")),
  karno_scaled = veteran$karno / 100
)
RoBSA.options(check_scaling = FALSE)
fit <- RoBSA(
  Surv(time, status) ~ treatment + karno_scaled,
  data   = df,
  priors = list(
    treatment    = prior_factor("normal", parameters = list(mean = 0.30, sd = 0.15),
                                truncation = list(0, Inf), contrast = "treatment"),
    karno_scaled = prior("normal", parameters = list(mean = 0, sd = 1))
  ),
  test_predictors = "treatment",
  prior_intercept = priors[["intercept"]],
  prior_aux       = priors[["aux"]],
  parallel = TRUE, seed = 1
)

# plot posterior distribution of the treatment effect from each model
plot_models(fit, parameter = "treatment")

}


}
