## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(Rnaught)

## -----------------------------------------------------------------------------
# Daily case counts.
cases <- c(1, 4, 10, 5, 3, 4, 19, 3, 3, 14, 4)

posterior <- seq_bayes(cases, mu = 8, kappa = 7, post = TRUE)

## -----------------------------------------------------------------------------
# `supp` is the support of the distribution, and `pmf` is its probability mass
# function.
post_mean <- sum(posterior$supp * posterior$pmf)
post_mean

# Verify that the following is true:
post_mean == seq_bayes(cases, mu = 8, kappa = 7)

## -----------------------------------------------------------------------------
post_mode <- posterior$supp[which.max(posterior$pmf)]
post_mode

## ----dpi = 192, echo = FALSE--------------------------------------------------
old_par <- par(mar = c(4.1, 4.1, 0.5, 0.5))

# Posterior.
plot(posterior$supp, posterior$pmf, xlab = "x", ylab = "p(x)",
  col = "black", lty = 1, type = "l"
)
# Uniform prior.
segments(x0 = 0, x1 = 7, y0 = 1 / (7 / 0.01 + 1), y1 = 1 / (7 / 0.01 + 1),
  col = "orange"
)
# Posterior mean.
abline(v = post_mean, col = "blue", lty = 2)
# Posterior mode.
abline(v = post_mode, col = "red", lty = 2)

legend("topright",
  legend = c("Prior", "Posterior", "Posterior mean", "Posterior mode"),
  col = c("orange", "black", "blue", "red"),
  lty = c(1, 1, 2, 2), cex = 0.5
)

par(old_par)

