% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmeans_clustering.R
\name{plot.k_hurst}
\alias{plot.k_hurst}
\title{Plot smoothed Hurst functions in each cluster with cluster centers}
\usage{
\method{plot}{k_hurst}(x, type = "estimates", ...)
}
\arguments{
\item{x}{Return from \code{\link{kmeans_hurst}}.}

\item{type}{The type of plot required.
\describe{
\item{\code{"estimates"}}{Only the smoothed Hurst functions in each cluster.}
\item{\code{"centers"}}{Only the cluster centers. Center denotes average of all smoothed Hurst functions in the cluster.}
\item{\code{"ec"}}{Both \code{"estimates"} and \code{"centers"}.}
}}

\item{...}{Other arguments.}
}
\value{
A ggplot object which is used to plot the relevant \code{type} of plot: \code{"estimates"}, \code{"centers"} or \code{"ec"}.
}
\description{
Creates a plot of the smoothed Hurst functions of realisations of processes (or time series) separately in each cluster with cluster centers using the return from
\code{\link{kmeans_hurst}}. Options to plot only estimates, only centers or both are available.
}
\examples{
\donttest{
#Simulation of multifractional processes
t <- seq(0, 1, by = (1/2)^10)
H1 <- function(t) {return(0.1 + 0*t)}
H2 <- function(t) {return(0.2 + 0.45*t)}
H3 <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
X.list.1 <- replicate(3, GHBMP(t, H1), simplify = FALSE)
X.list.2 <- replicate(3, GHBMP(t, H2), simplify = FALSE)
X.list.3 <- replicate(3, GHBMP(t, H3), simplify = FALSE)
X.list <- c(X.list.1, X.list.2, X.list.3)

#K-means clustering based on k=3 clusters
KC <- kmeans_hurst(X.list, k = 3)
print(KC)

#Plot of smoothed Hurst functions in each cluster with cluster centers
plot(KC, type = "ec")
}
}
\seealso{
\code{\link{kmeans_hurst}}
}
