\name{ResIndex}
\alias{ResIndex}
\title{
RESOLUTION INDEX: A SIMPLE YET EFFECTIVE METRIC OF FEATURE IMPORTANCE FOR CLASSIFICATION PROBLEMS
}
\description{
Provides an intuitive and explainable metric of Feature Importance for Classification Problems.
Resolution Index measures the extent to which a Feature clusters different classes when data is
sorted on it. User provides a DataFrame, column name of the Class, sample size and number of
iterations used for calculation. Resolution Index for each Feature is returned, which can be
effectively used to rank Features and reduce Dimensionality of Training data for ehnanced accuracy
of Supervised Learning Models.
}
\usage{
ResIndex(df, class, f=0.7, N=5, seed=NULL)
}
\arguments{
  \item{df}{
   R dataframe used for Classification
   }
  \item{class}{
   Column Name of Class
   }
  \item{f}{
   Sample size as fraction of total data size
   }
  \item{N}{
   Number of iterations
   }
  \item{seed}{
   seed if desired
   }
}
\details{
Resolution Index internally utilizes a metric called Transition. In a Classification Problem, it is count
of instances where the Class changes between consecutive records. An important Feature should reduce
Transition much higher than an irrelevant Feature, when data is sorted on it. This Resolution ability
of a Feature to segregate different Classes is calculated as a non-dimensional metric and can be used to
rank and filter Features in high dimensional data.
}
\value{
Maximum Transition (between 0 and 1)
Random Transition (between 0 and 1)
Resolution Index (for each Feature)
}
\references{
D. Theng and K. Bhoyar (2023) “Feature selection techniques for machine learning: a survey of more than two decades of research” <https://doi.org/10.1007/s10115-023-02010-5>
J. Tang, S. Alelyani and H. Liu (2014) “Feature selection for classification: A review” <https://doi.org/10.1201/b17320>
}
\author{
Anand Jha, Senior Data Scientist
}
\examples{
ResIndex(iris, Species)
ResIndex(iris, Species, 0.8, 10)
ResIndex(iris, Species, 0.8, 10, seed=123)
}
