% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qtest.R
\name{Qtest}
\alias{Qtest}
\title{Q-test to assess compatibility between original and replication effect estimate}
\usage{
Qtest(thetao, thetar, seo, ser)
}
\arguments{
\item{thetao}{Numeric vector of effect estimates from original studies.}

\item{thetar}{Numeric vector of effect estimates from replication studies.}

\item{seo}{Numeric vector of standard errors of the original effect estimates.}

\item{ser}{Numeric vector of standard errors of the replication effect estimates.}
}
\value{
p-value from Q-test.
}
\description{
Computes p-value from meta-analytic Q-test to assess compatibility between
original and replication effect estimate.
}
\details{
This function computes the p-value from a meta-analytic Q-test assessing
compatibility between original and replication effect estimate. Rejecting
compatibility when the p-value is smaller than alpha is equivalent with
rejecting compatibility based on a (1 - alpha) prediction interval.
}
\examples{
Qtest(thetao = 2, thetar = 0.5, seo = 1, ser = 0.5)
}
\references{
Hedges, L. V., Schauer, J. M. (2019). More Than One Replication Study Is
Needed for Unambiguous Tests of Replication. \emph{Journal of Educational and
Behavioral Statistics}, \bold{44}, 543-570.
\doi{10.3102/1076998619852953}
}
\seealso{
\code{\link{predictionInterval}}
}
\author{
Samuel Pawel
}
