#' Vector to list
#'
#' This function returns a list. The component of the list i contains the positions of the vector that are equal to i.
#'
#' @param clustering_vector  Vector
#'
#' @return Returns a list. The component of the list i contains the positions of the vector that are equal to i.
#'
#'
#' @examples
#'
#'  vect=c(1,1,1,1,1,2,2,2,2,2,3,3,3,3,3)
#'  vector_a_lista(vect)
#'
#' @export




vector_a_lista <- function(clustering_vector) {
  split(seq_along(clustering_vector), clustering_vector)
}
