# Tests for prior specifications
# Test file: tests/testthat/test-priors.R

test_that("normal_gamma prior works correctly", {
  prior <- normal_gamma(mu0 = 0, kappa0 = 1, alpha0 = 1, beta0 = 1)
  
  expect_s3_class(prior, "regime_prior")
  expect_equal(prior$type, "normal_gamma")
  expect_equal(prior$mu0, 0)
  expect_equal(prior$kappa0, 1)
  expect_equal(prior$alpha0, 1)
  expect_equal(prior$beta0, 1)
})

test_that("normal_gamma prior validates inputs", {
  expect_error(normal_gamma(kappa0 = -1))
  expect_error(normal_gamma(alpha0 = 0))
  expect_error(normal_gamma(beta0 = -1))
})

test_that("normal_known_var prior works correctly", {
  prior <- normal_known_var(mu0 = 0, sigma0 = 1, known_var = 1)
  
  expect_s3_class(prior, "regime_prior")
  expect_equal(prior$type, "normal_known_var")
  expect_equal(prior$known_var, 1)
})

test_that("normal_known_var prior validates inputs", {
  expect_error(normal_known_var(sigma0 = -1))
  expect_error(normal_known_var(known_var = 0))
})

test_that("normal_wishart prior works correctly", {
  mu0 <- c(0, 0)
  Psi0 <- diag(2)
  prior <- normal_wishart(mu0 = mu0, kappa0 = 1, nu0 = 3, Psi0 = Psi0)
  
  expect_s3_class(prior, "regime_prior")
  expect_equal(prior$type, "normal_wishart")
  expect_equal(prior$d, 2)
})

test_that("normal_wishart prior validates dimensions", {
  mu0 <- c(0, 0)
  Psi0 <- diag(3)  # Mismatched dimension
  expect_error(normal_wishart(mu0 = mu0, kappa0 = 1, nu0 = 3, Psi0 = Psi0))
})

test_that("poisson_gamma prior works correctly", {
  prior <- poisson_gamma(alpha0 = 1, beta0 = 1)
  
  expect_s3_class(prior, "regime_prior")
  expect_equal(prior$type, "poisson_gamma")
})

test_that("inverse_gamma_var prior works correctly", {
  prior <- inverse_gamma_var(alpha0 = 2, beta0 = 1, known_mean = 0)
  
  expect_s3_class(prior, "regime_prior")
  expect_equal(prior$type, "inverse_gamma_var")
  expect_equal(prior$known_mean, 0)
})

test_that("geometric_hazard prior works correctly", {
  hazard <- geometric_hazard(lambda = 0.01)
  
  expect_s3_class(hazard, "hazard_prior")
  expect_equal(hazard$type, "geometric")
  expect_equal(hazard$lambda, 0.01)
})

test_that("geometric_hazard validates lambda", {
  expect_error(geometric_hazard(lambda = 0))
  expect_error(geometric_hazard(lambda = 1.5))
})

test_that("constant_hazard prior works correctly", {
  hazard <- constant_hazard(lambda = 0.05)
  
  expect_s3_class(hazard, "hazard_prior")
  expect_equal(hazard$type, "geometric")  
})

test_that("negbin_hazard prior works correctly", {
  hazard <- negbin_hazard(r = 5, p = 0.1)
  
  expect_s3_class(hazard, "hazard_prior")
  expect_equal(hazard$type, "negative_binomial")
})

test_that("prior print methods work", {
  prior <- normal_gamma()
  expect_output(print(prior), "normal_gamma")
  
  hazard <- geometric_hazard()
  expect_output(print(hazard), "geometric")
})

