% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{parents}
\alias{parents}
\alias{ancestors}
\alias{children}
\alias{descendants}
\title{Ancestors and descendants of SNOMED CT concepts}
\usage{
parents(
  conceptIds,
  include_self = FALSE,
  SNOMED = getSNOMED(),
  TRANSITIVE = NULL,
  ...
)

ancestors(
  conceptIds,
  include_self = FALSE,
  SNOMED = getSNOMED(),
  TRANSITIVE = NULL,
  ...
)

children(
  conceptIds,
  include_self = FALSE,
  SNOMED = getSNOMED(),
  TRANSITIVE = NULL,
  ...
)

descendants(
  conceptIds,
  include_self = FALSE,
  SNOMED = getSNOMED(),
  TRANSITIVE = NULL,
  ...
)
}
\arguments{
\item{conceptIds}{character or integer64 vector of SNOMED concept IDs}

\item{include_self}{whether to include the original concept(s) in the
output, default = FALSE}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{TRANSITIVE}{transitive closure table for ancestors and
descendants, containing is-a relationships. This table can be 
created by createTransitive to speed up the ancestor / descendant
functions. If a TRANSITIVE table is provided, the SNOMED environment
is not used and relatedConcepts is not called. TRANSITIVE should be
a data.table with columns ancestorId and descendantId.}

\item{...}{other arguments to pass to relatedConcepts}
}
\value{
a bit64 vector of SNOMED CT concepts
}
\description{
Returns concepts with 'Is a' or inverse 'Is a'
relationship with a set of target concepts. 
Ancestors include parents and all higher relations.
Descendants include children and all lower relations.
}
\examples{
SNOMED <- sampleSNOMED()

parents('Heart failure')
children('Heart failure')
ancestors('Heart failure')
descendants('Heart failure')
}
\seealso{
[createTransitive()] for creation of TRANSITIVE table, and
  [relatedConcepts()] for the underlying function to extract
  SNOMED CT relationships.
}
